/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Locale;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.geotoolkit.factory.FactoryIteratorProvider;
import org.geotoolkit.factory.FactoryIteratorProviders;
import org.geotoolkit.factory.FactoryPrinter;
import org.geotoolkit.factory.FactoryRegistry;

public final class Factories {
    private static final EventListenerList LISTENERS = new EventListenerList();

    private Factories() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChangeListener(ChangeListener changeListener) {
        EventListenerList eventListenerList = LISTENERS;
        synchronized (eventListenerList) {
            Factories.removeChangeListener(changeListener);
            LISTENERS.add(ChangeListener.class, changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChangeListener(ChangeListener changeListener) {
        EventListenerList eventListenerList = LISTENERS;
        synchronized (eventListenerList) {
            LISTENERS.remove(ChangeListener.class, changeListener);
        }
    }

    static void fireConfigurationChanged(Class<?> clazz) {
        ChangeEvent changeEvent = new ChangeEvent(clazz);
        Object[] objectArray = LISTENERS.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public static void addFactoryIteratorProvider(FactoryIteratorProvider factoryIteratorProvider) {
        if (FactoryIteratorProviders.GLOBAL.addFactoryIteratorProvider(factoryIteratorProvider)) {
            Factories.fireConfigurationChanged(Factories.class);
        }
    }

    public static void removeFactoryIteratorProvider(FactoryIteratorProvider factoryIteratorProvider) {
        if (FactoryIteratorProviders.GLOBAL.removeFactoryIteratorProvider(factoryIteratorProvider)) {
            Factories.fireConfigurationChanged(Factories.class);
        }
    }

    public static void listProviders(Collection<FactoryRegistry> collection, Writer writer, Locale locale) throws IOException {
        new FactoryPrinter(collection).list(writer, locale);
    }
}

