/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.geotoolkit.factory.EmptyHints;
import org.geotoolkit.factory.FactoryComparator;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.util.InternationalString;

public abstract class Factory {
    private static final Hints.Key DONE = new Hints.Key(Set.class);
    private static final Hints.Key DISPOSED = new Hints.Key((Class)Date.class){

        @Override
        public String toString() {
            return "DISPOSED";
        }
    };
    public static final Hints EMPTY_HINTS = new EmptyHints();
    protected final Map<RenderingHints.Key, Object> hints = new LinkedHashMap<RenderingHints.Key, Object>();
    private final Map<RenderingHints.Key, Object> unmodifiableHints = Collections.unmodifiableMap(this.hints);

    protected Factory() {
    }

    protected void setOrdering(Organizer organizer) {
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return this.unmodifiableHints;
    }

    protected boolean hasCompatibleHints(Hints hints) {
        Map<RenderingHints.Key, ?> map = this.getImplementationHints();
        if (map == null) {
            return true;
        }
        if (map.containsKey(DISPOSED)) {
            return false;
        }
        Hints hints2 = null;
        HashSet<Factory> hashSet = (HashSet<Factory>)hints.get(DONE);
        for (Map.Entry<RenderingHints.Key, ?> entry : map.entrySet()) {
            Class[] classArray;
            RenderingHints.Key key = entry.getKey();
            Object obj = entry.getValue();
            Object object = hints.get(key);
            if (object != null) {
                if (object instanceof Class) {
                    if (!((Class)object).isInstance(obj)) {
                        return false;
                    }
                } else if (object instanceof Class[]) {
                    classArray = (Class[])object;
                    int n = 0;
                    do {
                        if (n < classArray.length) continue;
                        return false;
                    } while (!classArray[n++].isInstance(obj));
                } else if (!object.equals(obj)) {
                    return false;
                }
            }
            if (!(obj instanceof Factory)) continue;
            classArray = (Class[])obj;
            if (hashSet != null && hashSet.contains(classArray)) continue;
            if (hints2 == null) {
                hints2 = hints.clone();
                hints2.keySet().removeAll(map.keySet());
                if (hints2.isEmpty()) continue;
                if (hashSet == null && hints2.put(DONE, hashSet = new HashSet<Factory>()) != null) {
                    throw new AssertionError();
                }
                if (!hashSet.add(this)) {
                    throw new AssertionError();
                }
            }
            assert (hints2.isEmpty() || hints2.containsKey(DONE));
            if (hints2.size() <= 1) continue;
            assert (hashSet.contains(this));
            if (classArray.hasCompatibleHints(hints2)) continue;
            return false;
        }
        return true;
    }

    public ConformanceResult availability() {
        return new Availability();
    }

    protected synchronized void dispose(boolean bl) {
        this.hints.clear();
        this.hints.put(DISPOSED, new Date());
    }

    public final int hashCode() {
        return this.getClass().hashCode() ^ 0x649588A;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            Factory factory = (Factory)object;
            HashSet<FactoryComparator> hashSet = new HashSet<FactoryComparator>();
            return new FactoryComparator(this, factory).compare(hashSet);
        }
        return false;
    }

    public String toString() {
        String string = Factory.format(this);
        IdentityHashMap<Factory, String> identityHashMap = new IdentityHashMap<Factory, String>();
        identityHashMap.put(this, string);
        String string2 = Factory.format(this.getImplementationHints(), identityHashMap);
        return string + System.getProperty("line.separator", "\n") + string2;
    }

    static String toString(Map<?, ?> map) {
        return Factory.format(map, new IdentityHashMap<Factory, String>());
    }

    private static String format(Factory factory) {
        String string = Classes.getShortClassName(factory);
        if (factory instanceof AuthorityFactory) {
            string = string + "[\"" + ((AuthorityFactory)((Object)factory)).getAuthority().getTitle() + "\"]";
        }
        return string;
    }

    private static String format(Map<?, ?> map, Map<Factory, String> map2) {
        TableWriter tableWriter;
        try {
            tableWriter = new TableWriter(null, " ");
            Factory.format(tableWriter, map, "  ", map2);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return ((Object)tableWriter).toString();
    }

    private static void format(Writer writer, Map<?, ?> map, String string, Map<Factory, String> map2) throws IOException {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String string2;
            Object obj = entry.getKey();
            String string3 = obj instanceof RenderingHints.Key ? Hints.nameOf((RenderingHints.Key)obj) : String.valueOf(obj);
            Object object = entry.getValue();
            writer.write(string);
            writer.write(string3);
            int n = 58;
            Factory factory = null;
            if (object instanceof Factory) {
                factory = (Factory)object;
                object = Factory.format(factory);
                string2 = map2.put(factory, string3);
                if (string2 != null) {
                    map2.put(factory, string2);
                    n = 61;
                    object = string2;
                    factory = null;
                }
            }
            writer.write(9);
            writer.write(n);
            writer.write(32);
            writer.write(String.valueOf(object));
            writer.write(10);
            if (factory == null) continue;
            string2 = Utilities.spaces(string.length() + 2);
            Factory.format(writer, factory.getImplementationHints(), string2, map2);
        }
    }

    protected class Availability
    implements ConformanceResult {
        private InternationalString explanation;
        private final Throwable failureCause;

        public Availability() {
            this.failureCause = null;
        }

        public Availability(Throwable throwable) {
            this.failureCause = throwable;
        }

        @Override
        public Citation getSpecification() {
            return null;
        }

        @Override
        public synchronized InternationalString getExplanation() {
            if (this.explanation == null) {
                String string = null;
                for (Throwable throwable = this.failureCause; throwable != null; throwable = throwable.getCause()) {
                    String string2 = throwable.getLocalizedMessage();
                    if (string2 == null) continue;
                    string = string2;
                }
                this.explanation = string != null ? Vocabulary.formatInternational(88, string) : Descriptions.formatInternational(11, Factory.this.getClass());
            }
            return this.explanation;
        }

        public Throwable getFailureCause() {
            return this.failureCause;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean pass() {
            if (this.failureCause != null) {
                return false;
            }
            Factory factory = Factory.this;
            synchronized (factory) {
                return !Factory.this.hints.containsKey(DISPOSED);
            }
        }

        public String toString() {
            Class<?> clazz = this.getClass();
            while (clazz.isAnonymousClass()) {
                clazz = clazz.getSuperclass();
            }
            return Classes.getShortClassName(Factory.this) + '.' + clazz.getSimpleName() + '[' + this.pass() + ": " + this.getExplanation() + ']';
        }
    }

    protected final class Organizer {
        private final ServiceRegistry registry;
        private final Class<?> category;

        Organizer(ServiceRegistry serviceRegistry, Class<?> clazz) {
            this.registry = serviceRegistry;
            this.category = clazz;
        }

        private void setOrdering(Class<?> clazz, boolean bl, boolean bl2) {
            Factory factory = Factory.this;
            assert (this.category.isInstance(factory));
            if (!bl && !this.category.isAssignableFrom(clazz)) {
                throw new ClassCastException(Errors.format(66, clazz, this.category));
            }
            Class<?> clazz2 = clazz.isInstance(factory) ? factory.getClass() : null;
            Class<?> clazz3 = this.category;
            Iterator<?> iterator = bl ? this.registry.getServiceProviders(clazz3, false) : Collections.singleton(this.registry.getServiceProviderByClass(clazz)).iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!clazz.isInstance(obj) || clazz2 != null && clazz2.isInstance(obj)) continue;
                if (bl2) {
                    this.registry.setOrdering(clazz3, factory, obj);
                    continue;
                }
                this.registry.setOrdering(clazz3, obj, factory);
            }
        }

        private void setOrdering(String string, boolean bl, boolean bl2) {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logging.recoverableException(Organizer.class, bl2 ? "before" : "after", classNotFoundException);
                return;
            }
            this.setOrdering(clazz, bl, bl2);
        }

        public void before(Class<?> clazz, boolean bl) {
            this.setOrdering(clazz, bl, true);
        }

        public void before(String string, boolean bl) {
            this.setOrdering(string, bl, true);
        }

        public void after(Class<?> clazz, boolean bl) {
            this.setOrdering(clazz, bl, false);
        }

        public void after(String string, boolean bl) {
            this.setOrdering(string, bl, false);
        }
    }
}

