/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.geotoolkit.factory.FactoryRegistry;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.converter.Classes;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.Factory;

final class FactoryPrinter
implements Comparator<Class<?>> {
    private final Collection<FactoryRegistry> registries;

    public FactoryPrinter(FactoryRegistry factoryRegistry) {
        this.registries = Collections.singleton(factoryRegistry);
    }

    public FactoryPrinter(Collection<FactoryRegistry> collection) {
        this.registries = collection;
    }

    @Override
    public int compare(Class<?> clazz, Class<?> clazz2) {
        return Classes.getShortName(clazz).compareToIgnoreCase(Classes.getShortName(clazz2));
    }

    public void list(Writer writer, Locale locale) throws IOException {
        Object object;
        HashMap hashMap = new HashMap();
        for (FactoryRegistry object22 : this.registries) {
            object = object22.getCategories();
            while (object.hasNext()) {
                hashMap.put(object.next(), object22);
            }
        }
        Class[] classArray = hashMap.keySet().toArray(new Class[hashMap.size()]);
        Arrays.sort(classArray, this);
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        object = new TableWriter(writer);
        ((TableWriter)object).setMultiLinesCells(true);
        ((TableWriter)object).nextLine('\u2550');
        ((TableWriter)object).write(vocabulary.getString(238));
        ((TableWriter)object).nextColumn();
        ((TableWriter)object).write(vocabulary.getString(137));
        ((TableWriter)object).nextColumn();
        ((TableWriter)object).write(vocabulary.getString(287));
        ((TableWriter)object).nextColumn();
        ((TableWriter)object).write(vocabulary.getString(10));
        ((TableWriter)object).nextLine();
        ((TableWriter)object).nextLine('\u2550');
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = 0;
        for (Class clazz : classArray) {
            if (n++ != 0) {
                ((TableWriter)object).writeHorizontalSeparator();
            }
            ((TableWriter)object).write(Classes.getShortName(clazz));
            ((TableWriter)object).nextColumn();
            FactoryRegistry factoryRegistry = (FactoryRegistry)hashMap.get(clazz);
            Iterator iterator = factoryRegistry.getServiceProviders(clazz, null, null, null);
            int n2 = 0;
            while (iterator.hasNext()) {
                Citation citation;
                if (n2++ != 0) {
                    ((TableWriter)object).write(10);
                    stringBuilder.append('\n');
                    stringBuilder2.append('\n');
                }
                Object t = iterator.next();
                ((TableWriter)object).write(Classes.getShortClassName(t));
                if (t instanceof Factory) {
                    citation = ((Factory)t).getVendor();
                    stringBuilder.append(citation.getTitle().toString(locale));
                }
                if (!(t instanceof AuthorityFactory)) continue;
                citation = ((AuthorityFactory)t).getAuthority();
                Iterator<? extends Identifier> iterator2 = citation.getIdentifiers().iterator();
                String string = iterator2.hasNext() ? iterator2.next().getCode().toString() : citation.getTitle().toString(locale);
                stringBuilder2.append(string);
            }
            ((TableWriter)object).nextColumn();
            ((TableWriter)object).write(stringBuilder.toString());
            stringBuilder.setLength(0);
            ((TableWriter)object).nextColumn();
            ((TableWriter)object).write(stringBuilder2.toString());
            stringBuilder2.setLength(0);
            ((TableWriter)object).nextLine();
        }
        ((TableWriter)object).nextLine('\u2550');
        ((TableWriter)object).flush();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.list(stringWriter, null);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringWriter.toString();
    }
}

