/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryIteratorProvider;
import org.geotoolkit.factory.FactoryIteratorProviders;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.factory.FactoryPrinter;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.factory.RecursiveSearchException;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.quality.ConformanceResult;

public class FactoryRegistry
extends ServiceRegistry {
    protected static final Logger LOGGER = Logging.getLogger(FactoryRegistry.class);
    private static final Level DEBUG_LEVEL = Level.FINEST;
    private final FactoryIteratorProviders globalConfiguration = new FactoryIteratorProviders();
    private Set<Class<?>> needScanForPlugins;
    private final Set<Class<?>> scanningCategories = new HashSet();
    private final Set<Class<? extends Factory>> testingAvailability = new HashSet<Class<? extends Factory>>();
    private final Set<Factory> testingHints = new HashSet<Factory>();
    private transient Throwable failureCause;

    public FactoryRegistry(Class<?> clazz) {
        this(Collections.singleton(clazz));
    }

    public FactoryRegistry(Class<?>[] classArray) {
        this(Arrays.asList(classArray));
    }

    public FactoryRegistry(Collection<Class<?>> collection) {
        super(collection.iterator());
        Iterator<Class<?>> iterator = this.getCategories();
        while (iterator.hasNext()) {
            if (this.needScanForPlugins == null) {
                this.needScanForPlugins = new HashSet();
            }
            this.needScanForPlugins.add(iterator.next());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T> Iterator<T> getServiceProviders(final Class<T> clazz, ServiceRegistry.Filter filter, Hints hints, Hints.ClassKey classKey) {
        Class[] classArray;
        Object object;
        block6: {
            block7: {
                if (hints == null || classKey == null || hints.get(classKey) == null) break block7;
                object = (hints = hints.clone()).remove(classKey);
                if (object instanceof Class) {
                    classArray = new Class[]{(Class)object};
                    break block6;
                } else if (object instanceof Class[]) {
                    classArray = (Class[])((Class[])object).clone();
                    break block6;
                } else {
                    T t;
                    Set set = Collections.emptySet();
                    if (classKey.getValueClass().isInstance(object) && this.isAcceptable(t = clazz.cast(object), clazz, hints, filter, false)) {
                        set = Collections.singleton(t);
                    }
                    return set.iterator();
                }
            }
            classArray = null;
        }
        if (this.scanningCategories.contains(clazz)) {
            throw new RecursiveSearchException(clazz);
        }
        object = hints;
        ServiceRegistry.Filter filter2 = new ServiceRegistry.Filter((Hints)object, filter){
            final /* synthetic */ Hints val$userHints;
            final /* synthetic */ ServiceRegistry.Filter val$filter;
            {
                this.val$userHints = hints;
                this.val$filter = filter;
            }

            @Override
            public boolean filter(Object object) {
                if (classArray != null) {
                    int n = 0;
                    do {
                        if (n != classArray.length) continue;
                        return false;
                    } while (!classArray[n++].isInstance(object));
                }
                return FactoryRegistry.this.isAcceptable(clazz.cast(object), clazz, this.val$userHints, this.val$filter, false);
            }
        };
        this.synchronizeIteratorProviders();
        this.scanForPluginsIfNeeded(clazz);
        return this.getServiceProviders(clazz, filter2, true);
    }

    final <T> Iterator<T> getUnfilteredProviders(Class<T> clazz) {
        if (this.scanningCategories.contains(clazz)) {
            throw new RecursiveSearchException(clazz);
        }
        this.scanForPluginsIfNeeded(clazz);
        return this.getServiceProviders(clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getServiceProvider(Class<T> clazz, ServiceRegistry.Filter filter, Hints hints, Hints.ClassKey classKey) throws FactoryRegistryException {
        Throwable throwable = this.failureCause;
        try {
            T t = this.getOrCreateServiceProvider(clazz, filter, hints, classKey);
            return t;
        }
        finally {
            this.failureCause = throwable;
            this.reset();
        }
    }

    void reset() {
    }

    <T> T getOrCreateServiceProvider(Class<T> clazz, ServiceRegistry.Filter filter, Hints hints, Hints.ClassKey classKey) throws FactoryRegistryException {
        Class[] classArray;
        Object object;
        Class<Object> clazz2;
        this.synchronizeIteratorProviders();
        boolean bl = LOGGER.isLoggable(DEBUG_LEVEL);
        if (bl) {
            FactoryRegistry.debug("ENTRY", clazz, classKey, null, null);
        }
        Class clazz3 = null;
        if (classKey != null) {
            clazz2 = classKey.getValueClass();
            if (!clazz.isAssignableFrom(clazz2)) {
                if (bl) {
                    FactoryRegistry.debug("THROW", clazz, classKey, "unexpected type:", clazz2);
                }
                throw new IllegalArgumentException(Errors.format(74, classKey));
            }
            if (hints != null && (object = hints.get(classKey)) != null) {
                if (bl) {
                    FactoryRegistry.debug("CHECK", clazz, classKey, "user provided a", object.getClass());
                }
                if (clazz.isInstance(object)) {
                    if (bl) {
                        FactoryRegistry.debug("RETURN", clazz, classKey, "return hint as provided.", null);
                    }
                    return clazz.cast(object);
                }
                if ((hints = hints.clone()).remove(classKey) != object) {
                    throw new AssertionError(classKey);
                }
                if (object instanceof Class[]) {
                    classArray = (Class[])object;
                    int n = classArray.length;
                    for (int i = 0; i < n - 1; ++i) {
                        T t;
                        Class clazz4 = classArray[i];
                        if (bl) {
                            FactoryRegistry.debug("CHECK", clazz, classKey, "consider hint[" + i + ']', clazz4);
                        }
                        if ((t = this.getServiceImplementation(clazz, clazz4, filter, hints)) == null) continue;
                        if (bl) {
                            FactoryRegistry.debug("RETURN", clazz, classKey, "found implementation", t.getClass());
                        }
                        return t;
                    }
                    if (n != 0) {
                        clazz3 = classArray[n - 1];
                    }
                } else {
                    clazz3 = (Class)object;
                }
            }
        }
        if (bl && clazz3 != null) {
            FactoryRegistry.debug("CHECK", clazz, classKey, "consider hint[last]", clazz3);
        }
        if ((clazz2 = this.getServiceImplementation(clazz, clazz3, filter, hints)) != null) {
            if (bl) {
                FactoryRegistry.debug("RETURN", clazz, classKey, "found implementation", clazz2.getClass());
            }
            return (T)clazz2;
        }
        if (bl) {
            FactoryRegistry.debug("THROW", clazz, classKey, "could not find implementation.", null);
        }
        object = Errors.format(53, clazz3 != null ? clazz3 : clazz);
        classArray = new FactoryNotFoundException((String)object);
        this.initCause((FactoryNotFoundException)classArray);
        throw classArray;
    }

    final void initCause(FactoryNotFoundException factoryNotFoundException) {
        Throwable throwable = this.failureCause;
        if (throwable != null && factoryNotFoundException.getClass().equals(FactoryNotFoundException.class) && factoryNotFoundException.getCause() == null) {
            factoryNotFoundException.initCause(throwable);
        }
    }

    private static void debug(String string, Class<?> clazz, Hints.Key key, String string2, Class<?> clazz2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(Utilities.spaces(Math.max(1, 7 - string.length()))).append('(').append(Classes.getShortName(clazz));
        if (key != null) {
            stringBuilder.append(", ").append(key);
        }
        stringBuilder.append(')');
        if (string2 != null) {
            stringBuilder.append(": ").append(string2);
        }
        if (clazz2 != null) {
            stringBuilder.append(' ').append(Classes.getShortName(clazz2)).append('.');
        }
        LogRecord logRecord = new LogRecord(DEBUG_LEVEL, stringBuilder.toString());
        logRecord.setSourceClassName(FactoryRegistry.class.getName());
        logRecord.setSourceMethodName("getServiceProvider");
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    <T> T getServiceImplementation(Class<T> clazz, Class<?> clazz2, ServiceRegistry.Filter filter, Hints hints) {
        Iterator<T> iterator = this.getUnfilteredProviders(clazz);
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (clazz2 != null && !clazz2.isInstance(t) || !this.isAcceptable(t, clazz, hints, filter, true)) continue;
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> boolean isAcceptable(T t, Class<T> clazz, Hints hints, ServiceRegistry.Filter filter, boolean bl) {
        Factory factory;
        ConformanceResult conformanceResult = null;
        if (t instanceof Factory) {
            factory = (Factory)t;
            Class<?> clazz2 = factory.getClass();
            if (!this.testingAvailability.add(clazz2)) {
                throw new RecursiveSearchException(clazz2);
            }
            try {
                conformanceResult = factory.availability();
                if (conformanceResult.pass()) {
                    conformanceResult = null;
                } else {
                    this.unavailable(factory);
                    if (!bl || this.failureCause != null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                }
            }
            finally {
                if (!this.testingAvailability.remove(clazz2)) {
                    throw new AssertionError(clazz2);
                }
            }
        }
        if (filter != null && !filter.filter(t)) {
            return false;
        }
        if (t instanceof Factory) {
            factory = (Factory)t;
            if (hints != null && !hints.isEmpty()) {
                if (!this.testingHints.add(factory)) {
                    return false;
                }
                try {
                    if (!factory.hasCompatibleHints(hints)) {
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                finally {
                    if (!this.testingHints.remove(factory)) {
                        throw new AssertionError(factory);
                    }
                }
            }
        }
        if (!this.isAcceptable(t, clazz, hints)) {
            return false;
        }
        if (conformanceResult != null) {
            if (conformanceResult instanceof Factory.Availability) {
                this.failureCause = ((Factory.Availability)conformanceResult).getFailureCause();
            }
            return false;
        }
        return true;
    }

    protected <T> boolean isAcceptable(T t, Class<T> clazz, Hints hints) {
        return true;
    }

    void unavailable(Factory factory) {
    }

    public Set<ClassLoader> getClassLoaders() {
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>(6);
        for (int i = 0; i < 4; ++i) {
            ClassLoader classLoader;
            try {
                switch (i) {
                    case 0: {
                        classLoader = this.getClass().getClassLoader();
                        break;
                    }
                    case 1: {
                        classLoader = FactoryRegistry.class.getClassLoader();
                        break;
                    }
                    case 2: {
                        classLoader = Thread.currentThread().getContextClassLoader();
                        break;
                    }
                    case 3: {
                        classLoader = ClassLoader.getSystemClassLoader();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
            }
            catch (SecurityException securityException) {
                continue;
            }
            hashSet.add(classLoader);
        }
        hashSet.remove(null);
        ClassLoader[] classLoaderArray = hashSet.toArray(new ClassLoader[hashSet.size()]);
        for (int i = 0; i < classLoaderArray.length; ++i) {
            ClassLoader classLoader = classLoaderArray[i];
            try {
                while ((classLoader = classLoader.getParent()) != null) {
                    hashSet.remove(classLoader);
                }
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (hashSet.isEmpty()) {
            LOGGER.warning("No class loaders available.");
        }
        return hashSet;
    }

    public void scanForPlugins() {
        Set<ClassLoader> set = this.getClassLoaders();
        Iterator<Class<?>> iterator = this.getCategories();
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            this.scanForPlugins(set, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void scanForPlugins(Collection<ClassLoader> collection, Class<T> clazz) {
        Object object;
        Object object2;
        if (!this.scanningCategories.add(clazz)) {
            throw new RecursiveSearchException(clazz);
        }
        try {
            object2 = FactoryRegistry.getLogHeader(clazz);
            boolean bl = false;
            for (ClassLoader classLoader : collection) {
                bl |= this.register(FactoryRegistry.lookupProviders(clazz, classLoader), clazz, (StringBuilder)object2);
            }
            object = FactoryIteratorProviders.GLOBAL.getIteratorProviders();
            for (int i = 0; i < ((FactoryIteratorProvider[])object).length; ++i) {
                Iterator<T> iterator = object[i].iterator(clazz);
                if (iterator == null) continue;
                bl |= this.register(iterator, clazz, (StringBuilder)object2);
            }
            if (bl) {
                FactoryRegistry.log("scanForPlugins", (StringBuilder)object2);
            }
        }
        finally {
            if (!this.scanningCategories.remove(clazz)) {
                throw new AssertionError(clazz);
            }
        }
        object2 = this.getServiceProviders(clazz, false);
        while (object2.hasNext()) {
            Object e = object2.next();
            if (!(e instanceof Factory)) continue;
            Object object3 = object = (Factory)e;
            object3.getClass();
            ((Factory)object).setOrdering((Factory)object3.new Factory.Organizer(this, clazz));
        }
        this.pluginScanned(clazz);
    }

    private <T> void scanForPluginsIfNeeded(Class<?> clazz) {
        if (this.needScanForPlugins != null && this.needScanForPlugins.remove(clazz)) {
            if (this.needScanForPlugins.isEmpty()) {
                this.needScanForPlugins = null;
            }
            this.scanForPlugins(this.getClassLoaders(), clazz);
        }
    }

    void pluginScanned(Class<?> clazz) {
    }

    private <T> boolean register(Iterator<T> iterator, Class<T> clazz, StringBuilder stringBuilder) {
        boolean bl = false;
        String string = System.getProperty("line.separator", "\n");
        while (iterator.hasNext()) {
            Throwable throwable;
            Object object;
            try {
                object = iterator.next();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw outOfMemoryError;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FactoryRegistry.loadingFailure(clazz, noClassDefFoundError, false);
                continue;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                throwable = exceptionInInitializerError.getCause();
                if (throwable != null) {
                    FactoryRegistry.loadingFailure(clazz, throwable, true);
                }
                throw exceptionInInitializerError;
            }
            catch (Error error) {
                if (!Classes.getShortClassName(error).equals(Classes.getShortName(ServiceConfigurationError.class))) {
                    throw error;
                }
                FactoryRegistry.loadingFailure(clazz, error, true);
                continue;
            }
            Class<T> clazz2 = object.getClass().asSubclass(clazz);
            throwable = this.getServiceProviderByClass(clazz2);
            if (throwable != null) {
                object = throwable;
            }
            if (!this.registerServiceProvider(object, clazz)) continue;
            stringBuilder.append(string).append("  \u2022 ").append(clazz2.getCanonicalName());
            bl = true;
        }
        return bl;
    }

    private static void loadingFailure(Class<?> clazz, Throwable throwable, boolean bl) {
        String string = Classes.getShortName(clazz);
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(throwable));
        String string2 = throwable.getLocalizedMessage();
        if (string2 != null) {
            stringBuilder.append(": ").append(string2);
        }
        LogRecord logRecord = Loggings.format(Level.WARNING, 10, string, stringBuilder.toString());
        if (bl) {
            logRecord.setThrown(throwable);
        }
        logRecord.setSourceClassName(FactoryRegistry.class.getName());
        logRecord.setSourceMethodName("scanForPlugins");
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    private static StringBuilder getLogHeader(Class<?> clazz) {
        return new StringBuilder(Loggings.getResources(null).getString(25, clazz));
    }

    private static void log(String string, StringBuilder stringBuilder) {
        LogRecord logRecord = new LogRecord(Level.CONFIG, stringBuilder.toString());
        logRecord.setSourceClassName(FactoryRegistry.class.getName());
        logRecord.setSourceMethodName(string);
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    private void synchronizeIteratorProviders() {
        FactoryIteratorProvider[] factoryIteratorProviderArray = this.globalConfiguration.synchronizeIteratorProviders();
        if (factoryIteratorProviderArray == null) {
            return;
        }
        Iterator<Class<?>> iterator = this.getCategories();
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            if (this.needScanForPlugins != null && this.needScanForPlugins.contains(clazz)) continue;
            for (int i = 0; i < factoryIteratorProviderArray.length; ++i) {
                this.register(factoryIteratorProviderArray[i], clazz);
            }
        }
    }

    private <T> void register(FactoryIteratorProvider factoryIteratorProvider, Class<T> clazz) {
        StringBuilder stringBuilder;
        Iterator<T> iterator = factoryIteratorProvider.iterator(clazz);
        if (iterator != null && this.register(iterator, clazz, stringBuilder = FactoryRegistry.getLogHeader(clazz))) {
            FactoryRegistry.log("synchronizeIteratorProviders", stringBuilder);
        }
    }

    public <T> boolean setOrdering(Class<T> clazz, Comparator<T> comparator) {
        boolean bl = false;
        ArrayList<T> arrayList = new ArrayList<T>();
        Iterator<T> iterator = this.getServiceProviders(clazz, false);
        while (iterator.hasNext()) {
            T t = iterator.next();
            int n = arrayList.size();
            while (--n >= 0) {
                int n2;
                Object e = arrayList.get(n);
                try {
                    n2 = comparator.compare(t, e);
                }
                catch (ClassCastException classCastException) {
                    continue;
                }
                if (n2 > 0) {
                    bl |= this.setOrdering(clazz, t, e);
                    continue;
                }
                if (n2 >= 0) continue;
                bl |= this.setOrdering(clazz, e, t);
            }
            arrayList.add(t);
        }
        return bl;
    }

    public <T> boolean setOrdering(Class<T> clazz, ServiceRegistry.Filter filter, ServiceRegistry.Filter filter2) {
        return this.setOrUnsetOrdering(clazz, filter, filter2, true);
    }

    public <T> boolean unsetOrdering(Class<T> clazz, ServiceRegistry.Filter filter, ServiceRegistry.Filter filter2) {
        return this.setOrUnsetOrdering(clazz, filter, filter2, false);
    }

    private <T> boolean setOrUnsetOrdering(Class<T> clazz, ServiceRegistry.Filter filter, ServiceRegistry.Filter filter2, boolean bl) {
        boolean bl2 = false;
        Iterator<Class<?>> iterator = this.getCategories();
        while (iterator.hasNext()) {
            Class<?> clazz2 = iterator.next();
            if (!clazz.isAssignableFrom(clazz2)) continue;
            Class<T> clazz3 = clazz2.asSubclass(clazz);
            bl2 |= this.setOrUnsetOrdering(clazz3, bl, filter, filter2);
        }
        return bl2;
    }

    private <T> boolean setOrUnsetOrdering(Class<T> clazz, boolean bl, ServiceRegistry.Filter filter, ServiceRegistry.Filter filter2) {
        T t;
        boolean bl2 = false;
        ArrayList<T> arrayList = new ArrayList<T>();
        Iterator<T> iterator = this.getServiceProviders(clazz, true);
        while (iterator.hasNext()) {
            t = iterator.next();
            if (!filter.filter(t)) continue;
            arrayList.add(t);
        }
        if (arrayList != null) {
            iterator = this.getServiceProviders(clazz, false);
            while (iterator.hasNext()) {
                t = iterator.next();
                if (!filter2.filter(t)) continue;
                for (Object e : arrayList) {
                    if (e == t) continue;
                    if (bl) {
                        bl2 |= this.setOrdering(clazz, e, t);
                        continue;
                    }
                    bl2 |= this.unsetOrdering(clazz, e, t);
                }
            }
        }
        return bl2;
    }

    public String toString() {
        return new FactoryPrinter(this).toString();
    }
}

