/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.awt.RenderingHints;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Name;
import javax.sql.DataSource;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.opengis.util.InternationalString;

public class Hints
extends RenderingHints {
    private static final Map<RenderingHints.Key, Object> GLOBAL = new ConcurrentHashMap<RenderingHints.Key, Object>(8, 0.75f, 1);
    public static final ClassKey NAME_FACTORY = new ClassKey("org.opengis.util.NameFactory");
    public static final ClassKey CITATION_FACTORY = new ClassKey("org.opengis.metadata.citation.CitationFactory");
    public static final ClassKey CRS_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSAuthorityFactory");
    public static final ClassKey CS_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.cs.CSAuthorityFactory");
    public static final ClassKey DATUM_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumAuthorityFactory");
    public static final ClassKey CRS_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSFactory");
    public static final ClassKey CS_FACTORY = new ClassKey("org.opengis.referencing.cs.CSFactory");
    public static final ClassKey DATUM_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumFactory");
    public static final ClassKey COORDINATE_OPERATION_FACTORY = new ClassKey("org.opengis.referencing.operation.CoordinateOperationFactory");
    public static final ClassKey COORDINATE_OPERATION_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.operation.CoordinateOperationAuthorityFactory");
    public static final ClassKey MATH_TRANSFORM_FACTORY = new ClassKey("org.opengis.referencing.operation.MathTransformFactory");
    public static final Key DEFAULT_COORDINATE_REFERENCE_SYSTEM = new Key("org.opengis.referencing.crs.CoordinateReferenceSystem");
    public static final FileKey CRS_AUTHORITY_EXTRA_DIRECTORY = new FileKey(false);
    public static final Key EPSG_DATA_SOURCE = new DataSourceKey();
    public static final OptionKey DATUM_SHIFT_METHOD = new OptionKey("Molodensky", "Abridged Molodensky", "Molodenski", "Abridged_Molodenski", "Geocentric", "*");
    public static final Key LENIENT_DATUM_SHIFT = new Key(Boolean.class);
    public static final Key FORCE_LONGITUDE_FIRST_AXIS_ORDER = new Key(Boolean.class);
    public static final Key FORCE_AXIS_ORDER_HONORING = new Key(String.class);
    public static final Key FORCE_STANDARD_AXIS_DIRECTIONS = new Key(Boolean.class);
    public static final Key FORCE_STANDARD_AXIS_UNITS = new Key(Boolean.class);
    public static final Key VERSION = new Key("org.geotoolkit.util.Version");
    public static final Key JAI_INSTANCE = new Key("javax.media.jai.JAI");
    public static final Key TILE_ENCODING = new Key(String.class);
    public static final ClassKey GRID_COVERAGE_PROCESSOR = new ClassKey("org.opengis.coverage.processing.GridCoverageProcessor");
    public static final Key COVERAGE_PROCESSING_VIEW = new Key("org.geotoolkit.coverage.grid.ViewType");
    public static final Key SAMPLE_DIMENSION_TYPE = new Key("org.opengis.coverage.SampleDimensionType");
    public static final ClassKey POSITION_FACTORY = new ClassKey("org.opengis.geometry.PositionFactory");
    public static final ClassKey PRIMITIVE_FACTORY = new ClassKey("org.opengis.geometry.primitive.PrimitiveFactory");
    public static final ClassKey GEOMETRY_FACTORY = new ClassKey("org.opengis.geometry.coordinate.GeometryFactory");
    public static final ClassKey COMPLEX_FACTORY = new ClassKey("org.opengis.geometry.complex.ComplexFactory");
    public static final ClassKey AGGREGATE_FACTORY = new ClassKey("org.opengis.geometry.aggregate.AggregateFactory");
    public static final ClassKey FEATURE_FACTORY = new ClassKey("org.opengis.feature.FeatureFactory");
    public static final ClassKey FILTER_FACTORY = new ClassKey("org.opengis.filter.FilterFactory");
    public static final ClassKey STYLE_FACTORY = new ClassKey("org.opengis.style.StyleFactory");

    Hints(boolean bl) {
        super(null);
    }

    public Hints() {
        super(GLOBAL);
    }

    public Hints(RenderingHints.Key key, Object object) {
        this();
        this.put(key, object);
    }

    public Hints(RenderingHints.Key key, Object object, RenderingHints.Key key2, Object object2) {
        this(key, object);
        this.put(key2, object2);
    }

    public Hints(RenderingHints.Key key, Object object, RenderingHints.Key key2, Object object2, Object ... objectArray) {
        this(key, object, key2, object2);
        if ((objectArray.length & 1) != 0) {
            throw new IllegalArgumentException(Errors.format(158, objectArray.length));
        }
        int n = 0;
        while (n < objectArray.length) {
            this.put(objectArray[n++], objectArray[n++]);
        }
    }

    public Hints(Map<? extends RenderingHints.Key, ?> map) {
        this();
        if (map != null) {
            this.putAll(map);
        }
    }

    public Hints(RenderingHints renderingHints) {
        this();
        if (renderingHints != null) {
            this.putAll((Map<?, ?>)renderingHints);
        }
    }

    @Override
    public Hints clone() {
        return (Hints)super.clone();
    }

    public static Object getSystemDefault(RenderingHints.Key key) {
        return GLOBAL.get(key);
    }

    public static Object putSystemDefault(RenderingHints.Key key, Object object) {
        if (!key.isCompatibleValue(object)) {
            throw new IllegalArgumentException(Errors.format(63, Hints.nameOf(key), object));
        }
        Object object2 = GLOBAL.put(key, object);
        if (!Utilities.equals(object, object2)) {
            Factories.fireConfigurationChanged(Hints.class);
        }
        return object2;
    }

    public static Object removeSystemDefault(RenderingHints.Key key) {
        Object object = GLOBAL.remove(key);
        if (object != null) {
            Factories.fireConfigurationChanged(Hints.class);
        }
        return object;
    }

    @Override
    public String toString() {
        return Factory.toString(this);
    }

    static String nameOf(RenderingHints.Key key) {
        String string;
        if (key == null) {
            return null;
        }
        if (key instanceof Key) {
            return key.toString();
        }
        int n = 0;
        block7: while (true) {
            Class clazz;
            switch (n++) {
                case 0: {
                    clazz = RenderingHints.class;
                    break;
                }
                case 1: {
                    try {
                        clazz = Class.forName("javax.media.jai.JAI");
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        continue block7;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        continue block7;
                    }
                }
                default: {
                    return key.toString();
                }
            }
            if ((string = Hints.nameOf(clazz, key)) != null) break;
        }
        return string;
    }

    private static String nameOf(Class<?> clazz, RenderingHints.Key key) {
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object;
            Field field = fieldArray[i];
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                object = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            if (object != key) continue;
            return field.getName();
        }
        return null;
    }

    public static final class ClassKey
    extends Key {
        public ClassKey(Class<?> clazz) {
            super(clazz);
        }

        public ClassKey(String string) {
            super(string);
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Class[]) {
                Class[] classArray = (Class[])object;
                for (int i = 0; i < classArray.length; ++i) {
                    if (this.isCompatibleValue(classArray[i])) continue;
                    return false;
                }
                return classArray.length != 0;
            }
            if (object instanceof Class) {
                int n;
                Class clazz = (Class)object;
                Class<?> clazz2 = this.getValueClass();
                if (clazz2.isAssignableFrom(clazz)) {
                    return true;
                }
                return clazz2.isInterface() && !clazz.isInterface() && Modifier.isAbstract(n = clazz.getModifiers()) && !Modifier.isFinal(n);
            }
            return super.isCompatibleValue(object);
        }
    }

    static final class DataSourceKey
    extends Key {
        public DataSourceKey() {
            super(DataSource.class);
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return object == null || object instanceof DataSource || object instanceof String || object instanceof Name;
        }
    }

    public static final class FileKey
    extends Key {
        private final boolean writable;

        public FileKey(boolean bl) {
            super(File.class);
            this.writable = bl;
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            File file;
            if (object instanceof File) {
                file = (File)object;
            } else if (object instanceof String) {
                file = new File((String)object);
            } else {
                return false;
            }
            if (this.writable) {
                if (file.exists()) {
                    return file.canWrite();
                }
                File file2 = file.getParentFile();
                return file2 != null && file2.canWrite();
            }
            return file.canRead();
        }
    }

    public static final class IntegerKey
    extends Key {
        private final int number;

        public IntegerKey(int n) {
            super(Integer.class);
            this.number = n;
        }

        public int getDefault() {
            return this.number;
        }

        public int toValue(Hints hints) {
            if (hints != null) {
                Object object = hints.get(this);
                if (object instanceof Number) {
                    return ((Number)object).intValue();
                }
                if (object instanceof CharSequence) {
                    return Integer.parseInt(object.toString());
                }
            }
            return this.number;
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            if (object instanceof Short || object instanceof Integer) {
                return true;
            }
            if (object instanceof String || object instanceof InternationalString) {
                try {
                    Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.getLogger(IntegerKey.class).finer(numberFormatException.toString());
                }
            }
            return false;
        }
    }

    public static class Key
    extends RenderingHints.Key {
        private static int count;
        private final String className;
        private transient Class<?> valueClass;

        public Key(Class<?> clazz) {
            this(clazz.getName());
            this.valueClass = clazz;
        }

        public Key(String string) {
            super(Key.count());
            this.className = string;
        }

        private static synchronized int count() {
            return count++;
        }

        public Class<?> getValueClass() {
            if (this.valueClass == null) {
                try {
                    this.valueClass = Class.forName(this.className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logging.unexpectedException(Key.class, "getValueClass", classNotFoundException);
                    this.valueClass = Object.class;
                }
            }
            return this.valueClass;
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return this.getValueClass().isInstance(object);
        }

        public String toString() {
            Class clazz;
            String string;
            int n = 0;
            do {
                switch (n++) {
                    case 0: {
                        clazz = Hints.class;
                        break;
                    }
                    case 1: {
                        clazz = this.getValueClass();
                        break;
                    }
                    default: {
                        return super.toString();
                    }
                }
            } while ((string = Hints.nameOf(clazz, this)) == null);
            return string;
        }
    }

    public static final class OptionKey
    extends Key {
        private final Set<String> options;
        private final boolean wildcard;

        public OptionKey(String ... stringArray) {
            super(String.class);
            TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(stringArray));
            this.wildcard = treeSet.remove("*");
            this.options = Collections.unmodifiableSet(treeSet);
        }

        public Set<String> getOptions() {
            return this.options;
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return this.wildcard ? object instanceof String : this.options.contains(object);
        }
    }
}

