/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.internal.Threads;

final class ShutdownHook
extends Thread {
    static final ShutdownHook INSTANCE = new ShutdownHook();
    private ServiceRegistry[] registries = new ServiceRegistry[0];

    private ShutdownHook() {
        super(Threads.SHUTDOWN_HOOKS, "FactoryCleaner");
    }

    synchronized void register(ServiceRegistry serviceRegistry) {
        int n = this.registries.length;
        this.registries = Arrays.copyOf(this.registries, n + 1);
        this.registries[n] = serviceRegistry;
    }

    @Override
    public synchronized void run() {
        for (ServiceRegistry serviceRegistry : this.registries) {
            Iterator<Class<?>> iterator = serviceRegistry.getCategories();
            while (iterator.hasNext()) {
                Class<?> clazz = iterator.next();
                Iterator<?> iterator2 = serviceRegistry.getServiceProviders(clazz, false);
                while (iterator2.hasNext()) {
                    Object obj = iterator2.next();
                    if (!(obj instanceof Factory)) continue;
                    ((Factory)obj).dispose(true);
                }
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(INSTANCE);
    }
}

