/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractDirectPosition
implements DirectPosition {
    protected AbstractDirectPosition() {
    }

    @Override
    public DirectPosition getDirectPosition() {
        return this;
    }

    public void setDirectPosition(DirectPosition directPosition) {
        int n = this.getDimension();
        if (directPosition != null) {
            AbstractDirectPosition.ensureDimensionMatch("position", directPosition.getDimension(), n);
            for (int i = 0; i < n; ++i) {
                this.setOrdinate(i, directPosition.getOrdinate(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.setOrdinate(i, Double.NaN);
            }
        }
    }

    @Override
    public double[] getCoordinate() {
        double[] dArray = new double[this.getDimension()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getOrdinate(i);
        }
        return dArray;
    }

    static void checkCoordinateReferenceSystemDimension(CoordinateReferenceSystem coordinateReferenceSystem, int n) throws MismatchedDimensionException {
        int n2;
        if (coordinateReferenceSystem != null && (n2 = coordinateReferenceSystem.getCoordinateSystem().getDimension()) != n) {
            throw new MismatchedDimensionException(Errors.format(101, coordinateReferenceSystem.getName().getCode(), n2, n));
        }
    }

    static void ensureDimensionMatch(String string, int n, int n2) throws MismatchedDimensionException {
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format(101, string, n, n2));
        }
    }

    public String toString() {
        return AbstractDirectPosition.toString(this);
    }

    static String toString(DirectPosition directPosition) {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(directPosition)).append('[');
        int n = directPosition.getDimension();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(directPosition.getOrdinate(i));
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public int hashCode() {
        return AbstractDirectPosition.hashCode(this);
    }

    static int hashCode(DirectPosition directPosition) {
        int n = directPosition.getDimension();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            long l = Double.doubleToLongBits(directPosition.getOrdinate(i));
            n2 = 31 * n2 + ((int)l ^ (int)(l >>> 32));
        }
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            n2 += coordinateReferenceSystem.hashCode();
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DirectPosition) {
            DirectPosition directPosition = (DirectPosition)object;
            int n = this.getDimension();
            if (n == directPosition.getDimension()) {
                for (int i = 0; i < n; ++i) {
                    if (Utilities.equals(this.getOrdinate(i), directPosition.getOrdinate(i))) continue;
                    return false;
                }
                if (Utilities.equals(this.getCoordinateReferenceSystem(), directPosition.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == ((Object)directPosition).hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }
}

