/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.io.Serializable;
import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPosition1D
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3235094562875693710L;
    private CoordinateReferenceSystem crs;
    public double ordinate;

    public DirectPosition1D() {
    }

    public DirectPosition1D(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.setCoordinateReferenceSystem(coordinateReferenceSystem);
    }

    public DirectPosition1D(double d) {
        this.ordinate = d;
    }

    public DirectPosition1D(DirectPosition directPosition) {
        this.setLocation(directPosition);
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        DirectPosition1D.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, 1);
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final int getDimension() {
        return 1;
    }

    @Override
    public double[] getCoordinate() {
        return new double[]{this.ordinate};
    }

    @Override
    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.ordinate;
        }
        throw new IndexOutOfBoundsException(Errors.format(85, n));
    }

    @Override
    public final void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        if (n != 0) {
            throw new IndexOutOfBoundsException(Errors.format(85, n));
        }
        this.ordinate = d;
    }

    public void setLocation(DirectPosition directPosition) throws MismatchedDimensionException {
        AbstractDirectPosition.ensureDimensionMatch("position", directPosition.getDimension(), 1);
        this.setCoordinateReferenceSystem(directPosition.getCoordinateReferenceSystem());
        this.ordinate = directPosition.getOrdinate(0);
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.ordinate);
        int n = 31 + ((int)l ^ (int)(l >>> 32));
        if (this.crs != null) {
            n += this.crs.hashCode();
        }
        assert (n == super.hashCode());
        return n;
    }

    @Override
    public DirectPosition1D clone() {
        try {
            return (DirectPosition1D)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }
}

