/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Rectangle2D;
import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.geometry.AbstractEnvelope;
import org.geotoolkit.geometry.DirectPosition2D;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Envelope2D
extends Rectangle2D.Double
implements Envelope,
Cloneable {
    private static final long serialVersionUID = -3319231220761419350L;
    private CoordinateReferenceSystem crs;

    public Envelope2D() {
    }

    public Envelope2D(Envelope envelope) {
        super(envelope.getMinimum(0), envelope.getMinimum(1), envelope.getSpan(0), envelope.getSpan(1));
        int n = envelope.getDimension();
        if (n != 2) {
            throw new MismatchedDimensionException(Errors.format(136, n));
        }
        this.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
    }

    public Envelope2D(CoordinateReferenceSystem coordinateReferenceSystem, Rectangle2D rectangle2D) {
        super(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.setCoordinateReferenceSystem(coordinateReferenceSystem);
    }

    public Envelope2D(CoordinateReferenceSystem coordinateReferenceSystem, double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        this.setCoordinateReferenceSystem(coordinateReferenceSystem);
    }

    public Envelope2D(DirectPosition2D directPosition2D, DirectPosition2D directPosition2D2) throws MismatchedReferenceSystemException {
        super(Math.min(directPosition2D.x, directPosition2D2.x), Math.min(directPosition2D.y, directPosition2D2.y), Math.abs(directPosition2D2.x - directPosition2D.x), Math.abs(directPosition2D2.y - directPosition2D.y));
        this.setCoordinateReferenceSystem(AbstractEnvelope.getCoordinateReferenceSystem(directPosition2D, directPosition2D2));
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, this.getDimension());
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final int getDimension() {
        return 2;
    }

    @Override
    public DirectPosition2D getLowerCorner() {
        return new DirectPosition2D(this.crs, this.getMinX(), this.getMinY());
    }

    @Override
    public DirectPosition2D getUpperCorner() {
        return new DirectPosition2D(this.crs, this.getMaxX(), this.getMaxY());
    }

    private static IndexOutOfBoundsException indexOutOfBounds(int n) {
        return new IndexOutOfBoundsException(Errors.format(85, n));
    }

    @Override
    public final double getMinimum(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
        }
        throw Envelope2D.indexOutOfBounds(n);
    }

    @Override
    public final double getMaximum(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
        }
        throw Envelope2D.indexOutOfBounds(n);
    }

    @Override
    public final double getMedian(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.getCenterX();
            }
            case 1: {
                return this.getCenterY();
            }
        }
        throw Envelope2D.indexOutOfBounds(n);
    }

    @Override
    public final double getSpan(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
        }
        throw Envelope2D.indexOutOfBounds(n);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            CoordinateReferenceSystem coordinateReferenceSystem = object instanceof Envelope2D ? ((Envelope2D)object).crs : null;
            return Utilities.equals(this.crs, coordinateReferenceSystem);
        }
        return false;
    }

    public boolean boundsEquals(Envelope envelope, int n, int n2, double d) {
        d *= 0.5 * (this.width + this.height);
        for (int i = 0; i < 4; ++i) {
            double d2;
            double d3;
            int n3;
            int n4 = i & 1;
            int n5 = n3 = n4 == 0 ? n : n2;
            if ((i & 2) == 0) {
                d3 = this.getMinimum(n4);
                d2 = envelope.getMinimum(n3);
            } else {
                d3 = this.getMaximum(n4);
                d2 = envelope.getMaximum(n3);
            }
            if (Math.abs(d3 - d2) <= d) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return AbstractEnvelope.toString(this);
    }
}

