/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeneralDirectPosition
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9071833698385715524L;
    public final double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralDirectPosition(CoordinateReferenceSystem coordinateReferenceSystem) {
        this(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        this.crs = coordinateReferenceSystem;
    }

    public GeneralDirectPosition(int n) throws NegativeArraySizeException {
        this.ordinates = new double[n];
    }

    public GeneralDirectPosition(double[] dArray) {
        this.ordinates = (double[])dArray.clone();
    }

    public GeneralDirectPosition(double d, double d2) {
        this.ordinates = new double[]{d, d2};
    }

    public GeneralDirectPosition(double d, double d2, double d3) {
        this.ordinates = new double[]{d, d2, d3};
    }

    public GeneralDirectPosition(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public GeneralDirectPosition(DirectPosition directPosition) {
        this.ordinates = directPosition.getCoordinate();
        this.crs = directPosition.getCoordinateReferenceSystem();
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        GeneralDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, this.getDimension());
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final int getDimension() {
        return this.ordinates.length;
    }

    @Override
    public final double[] getCoordinate() {
        return (double[])this.ordinates.clone();
    }

    @Override
    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        return this.ordinates[n];
    }

    @Override
    public final void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        this.ordinates[n] = d;
    }

    public final void setLocation(DirectPosition directPosition) throws MismatchedDimensionException {
        GeneralDirectPosition.ensureDimensionMatch("position", directPosition.getDimension(), this.ordinates.length);
        this.setCoordinateReferenceSystem(directPosition.getCoordinateReferenceSystem());
        for (int i = 0; i < this.ordinates.length; ++i) {
            this.ordinates[i] = directPosition.getOrdinate(i);
        }
    }

    public final void setLocation(GeneralDirectPosition generalDirectPosition) throws MismatchedDimensionException {
        GeneralDirectPosition.ensureDimensionMatch("position", generalDirectPosition.ordinates.length, this.ordinates.length);
        this.setCoordinateReferenceSystem(generalDirectPosition.crs);
        System.arraycopy(generalDirectPosition.ordinates, 0, this.ordinates, 0, this.ordinates.length);
    }

    public final void setLocation(Point2D point2D) throws MismatchedDimensionException {
        if (this.ordinates.length != 2) {
            throw new MismatchedDimensionException(Errors.format(136, this.ordinates.length));
        }
        this.ordinates[0] = point2D.getX();
        this.ordinates[1] = point2D.getY();
    }

    public Point2D toPoint2D() throws IllegalStateException {
        if (this.ordinates.length != 2) {
            throw new IllegalStateException(Errors.format(136, this.ordinates.length));
        }
        return new Point2D.Double(this.ordinates[0], this.ordinates[1]);
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            n += this.crs.hashCode();
        }
        assert (n == super.hashCode());
        return n;
    }

    @Override
    public GeneralDirectPosition clone() {
        return new GeneralDirectPosition(this.ordinates);
    }
}

