/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import org.geotoolkit.display.shape.XRectangle2D;
import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.geometry.AbstractEnvelope;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.metadata.iso.spatial.PixelTranslation;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeneralEnvelope
extends AbstractEnvelope
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1752330560227688940L;
    private double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralEnvelope(int n) {
        this.ordinates = new double[n * 2];
    }

    public GeneralEnvelope(double d, double d2) {
        this.ordinates = new double[]{d, d2};
        GeneralEnvelope.checkCoordinates(this.ordinates);
    }

    public GeneralEnvelope(double[] dArray, double[] dArray2) throws IllegalArgumentException {
        GeneralEnvelope.ensureNonNull("minDP", dArray);
        GeneralEnvelope.ensureNonNull("maxDP", dArray2);
        GeneralEnvelope.ensureSameDimension(dArray.length, dArray2.length);
        this.ordinates = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, this.ordinates, 0, dArray.length);
        System.arraycopy(dArray2, 0, this.ordinates, dArray.length, dArray2.length);
        GeneralEnvelope.checkCoordinates(this.ordinates);
    }

    public GeneralEnvelope(GeneralDirectPosition generalDirectPosition, GeneralDirectPosition generalDirectPosition2) throws MismatchedReferenceSystemException, IllegalArgumentException {
        this(generalDirectPosition.ordinates, generalDirectPosition2.ordinates);
        this.crs = GeneralEnvelope.getCoordinateReferenceSystem(generalDirectPosition, generalDirectPosition2);
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(this.crs, this.ordinates.length / 2);
    }

    public GeneralEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) {
        this(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        this.crs = coordinateReferenceSystem;
    }

    public GeneralEnvelope(Envelope envelope) {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        if (envelope instanceof GeneralEnvelope) {
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)envelope;
            this.ordinates = (double[])generalEnvelope.ordinates.clone();
            this.crs = generalEnvelope.crs;
        } else {
            this.crs = envelope.getCoordinateReferenceSystem();
            int n = envelope.getDimension();
            this.ordinates = new double[2 * n];
            for (int i = 0; i < n; ++i) {
                this.ordinates[i] = envelope.getMinimum(i);
                this.ordinates[i + n] = envelope.getMaximum(i);
            }
            GeneralEnvelope.checkCoordinates(this.ordinates);
        }
    }

    public GeneralEnvelope(GeographicBoundingBox geographicBoundingBox) {
        GeneralEnvelope.ensureNonNull("box", geographicBoundingBox);
        this.ordinates = new double[]{geographicBoundingBox.getWestBoundLongitude(), geographicBoundingBox.getSouthBoundLatitude(), geographicBoundingBox.getEastBoundLongitude(), geographicBoundingBox.getNorthBoundLatitude()};
        this.crs = DefaultGeographicCRS.WGS84;
    }

    public GeneralEnvelope(Rectangle2D rectangle2D) {
        GeneralEnvelope.ensureNonNull("rect", rectangle2D);
        this.ordinates = new double[]{rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()};
        GeneralEnvelope.checkCoordinates(this.ordinates);
    }

    public GeneralEnvelope(GridEnvelope gridEnvelope, PixelInCell pixelInCell, MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem) throws IllegalArgumentException {
        GeneralEnvelope generalEnvelope;
        GeneralEnvelope.ensureNonNull("gridEnvelope", gridEnvelope);
        GeneralEnvelope.ensureNonNull("gridToCRS", mathTransform);
        int n = gridEnvelope.getDimension();
        int n2 = mathTransform.getSourceDimensions();
        int n3 = mathTransform.getTargetDimensions();
        GeneralEnvelope.ensureSameDimension(n, n2);
        GeneralEnvelope.ensureSameDimension(n, n3);
        this.ordinates = new double[n2 * 2];
        double d = PixelTranslation.getPixelTranslation(pixelInCell) + 0.5;
        for (int i = 0; i < n2; ++i) {
            this.setRange(i, (double)gridEnvelope.getLow(i) - d, (double)gridEnvelope.getHigh(i) - (d - 1.0));
        }
        try {
            generalEnvelope = CRS.transform(mathTransform, (Envelope)this);
        }
        catch (TransformException transformException) {
            throw new IllegalArgumentException(Errors.format(15, Classes.getClass(mathTransform)), transformException);
        }
        assert (generalEnvelope.ordinates.length == this.ordinates.length);
        System.arraycopy(generalEnvelope.ordinates, 0, this.ordinates, 0, this.ordinates.length);
        this.setCoordinateReferenceSystem(coordinateReferenceSystem);
    }

    private static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, string));
        }
    }

    private static void ensureSameDimension(int n, int n2) throws MismatchedDimensionException {
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format(100, n, n2));
        }
    }

    private static void checkCoordinates(double[] dArray) throws IllegalArgumentException {
        int n = dArray.length / 2;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] <= dArray[n + i]) continue;
            throw new IllegalArgumentException(Errors.format(71, i));
        }
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        assert (this.crs == null || this.crs.getCoordinateSystem().getDimension() == this.getDimension());
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, this.getDimension());
        this.crs = coordinateReferenceSystem;
    }

    public boolean normalize(boolean bl) {
        boolean bl2 = false;
        if (this.crs != null) {
            Envelope envelope;
            double d;
            IdentifiedObject identifiedObject;
            int n = this.ordinates.length / 2;
            CoordinateSystem coordinateSystem = this.crs.getCoordinateSystem();
            for (int i = 0; i < n; ++i) {
                double d2;
                int n2 = i + n;
                identifiedObject = coordinateSystem.getAxis(i);
                double d3 = identifiedObject.getMinimumValue();
                d = identifiedObject.getMaximumValue();
                RangeMeaning rangeMeaning = identifiedObject.getRangeMeaning();
                if (RangeMeaning.EXACT.equals(rangeMeaning)) {
                    if (this.ordinates[i] < d3) {
                        this.ordinates[i] = d3;
                        bl2 = true;
                    }
                    if (!(this.ordinates[n2] > d)) continue;
                    this.ordinates[n2] = d;
                    bl2 = true;
                    continue;
                }
                if (!RangeMeaning.WRAPAROUND.equals(rangeMeaning) || !((d2 = d - d3) > 0.0) || !(d2 < Double.POSITIVE_INFINITY)) continue;
                double d4 = Math.floor((this.ordinates[i] - d3) / d2) * d2;
                if (d4 != 0.0) {
                    int n3 = i;
                    this.ordinates[n3] = this.ordinates[n3] - d4;
                    int n4 = n2;
                    this.ordinates[n4] = this.ordinates[n4] - d4;
                    bl2 = true;
                }
                if (!(this.ordinates[n2] > d)) continue;
                this.ordinates[i] = d3;
                this.ordinates[n2] = d;
                bl2 = true;
            }
            if (bl && (envelope = CRS.getEnvelope(this.crs)) != null) {
                CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
                if (coordinateReferenceSystem == null) {
                    this.intersect(envelope);
                } else {
                    identifiedObject = coordinateReferenceSystem.getCoordinateSystem();
                    int n5 = identifiedObject.getDimension();
                    for (int i = 0; i < n5; ++i) {
                        d = envelope.getMinimum(i);
                        double d5 = envelope.getMaximum(i);
                        AxisDirection axisDirection = identifiedObject.getAxis(i).getDirection();
                        for (int j = 0; j < n; ++j) {
                            if (!axisDirection.equals(coordinateSystem.getAxis(j).getDirection())) continue;
                            int n6 = j + n;
                            if (this.ordinates[j] < d) {
                                this.ordinates[j] = d;
                            }
                            if (!(this.ordinates[n6] > d5)) continue;
                            this.ordinates[n6] = d5;
                        }
                    }
                }
            }
        }
        return bl2;
    }

    @Override
    public final int getDimension() {
        return this.ordinates.length / 2;
    }

    @Override
    public DirectPosition getLowerCorner() {
        int n = this.ordinates.length / 2;
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n);
        System.arraycopy(this.ordinates, 0, generalDirectPosition.ordinates, 0, n);
        generalDirectPosition.setCoordinateReferenceSystem(this.crs);
        return generalDirectPosition;
    }

    @Override
    public DirectPosition getUpperCorner() {
        int n = this.ordinates.length / 2;
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n);
        System.arraycopy(this.ordinates, n, generalDirectPosition.ordinates, 0, n);
        generalDirectPosition.setCoordinateReferenceSystem(this.crs);
        return generalDirectPosition;
    }

    public DirectPosition getMedian() {
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(this.ordinates.length / 2);
        int n = generalDirectPosition.ordinates.length;
        while (--n >= 0) {
            generalDirectPosition.ordinates[n] = this.getMedian(n);
        }
        generalDirectPosition.setCoordinateReferenceSystem(this.crs);
        return generalDirectPosition;
    }

    private static IndexOutOfBoundsException indexOutOfBounds(int n) {
        return new IndexOutOfBoundsException(Errors.format(85, n));
    }

    @Override
    public final double getMinimum(int n) throws IndexOutOfBoundsException {
        if (n < this.ordinates.length / 2) {
            return this.ordinates[n];
        }
        throw GeneralEnvelope.indexOutOfBounds(n);
    }

    @Override
    public final double getMaximum(int n) throws IndexOutOfBoundsException {
        if (n >= 0) {
            return this.ordinates[n + this.ordinates.length / 2];
        }
        throw GeneralEnvelope.indexOutOfBounds(n);
    }

    @Override
    public final double getMedian(int n) throws IndexOutOfBoundsException {
        return 0.5 * (this.ordinates[n] + this.ordinates[n + this.ordinates.length / 2]);
    }

    @Override
    public final double getSpan(int n) throws IndexOutOfBoundsException {
        return this.ordinates[n + this.ordinates.length / 2] - this.ordinates[n];
    }

    public double getSpan(int n, Unit<?> unit) throws IndexOutOfBoundsException, ConversionException {
        Unit<?> unit2;
        double d = this.getSpan(n);
        if (this.crs != null && (unit2 = this.crs.getCoordinateSystem().getAxis(n).getUnit()) != null) {
            d = unit2.getConverterTo(unit).convert(d);
        }
        return d;
    }

    public void setRange(int n, double d, double d2) throws IndexOutOfBoundsException {
        if (d > d2) {
            d = d2 = 0.5 * (d + d2);
        }
        if (n < 0) {
            throw GeneralEnvelope.indexOutOfBounds(n);
        }
        this.ordinates[n + this.ordinates.length / 2] = d2;
        this.ordinates[n] = d;
    }

    public void setEnvelope(double ... dArray) {
        if ((dArray.length & 1) != 0) {
            throw new IllegalArgumentException(Errors.format(158, dArray.length));
        }
        int n = dArray.length >>> 1;
        int n2 = this.ordinates.length >>> 1;
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format(101, "ordinates", n, n2));
        }
        GeneralEnvelope.checkCoordinates(dArray);
        System.arraycopy(dArray, 0, this.ordinates, 0, dArray.length);
    }

    public void setEnvelope(GeneralEnvelope generalEnvelope) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("envelope", generalEnvelope);
        AbstractDirectPosition.ensureDimensionMatch("envelope", generalEnvelope.getDimension(), this.getDimension());
        System.arraycopy(generalEnvelope.ordinates, 0, this.ordinates, 0, this.ordinates.length);
        if (generalEnvelope.crs != null) {
            this.crs = generalEnvelope.crs;
            assert (this.crs.getCoordinateSystem().getDimension() == this.getDimension()) : this.crs;
            assert (!generalEnvelope.getClass().equals(this.getClass()) || this.equals(generalEnvelope)) : generalEnvelope;
        }
    }

    public void setToInfinite() {
        int n = this.ordinates.length / 2;
        Arrays.fill(this.ordinates, 0, n, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.ordinates, n, this.ordinates.length, Double.POSITIVE_INFINITY);
        assert (this.isInfinite()) : this;
    }

    public boolean isInfinite() {
        for (int i = 0; i < this.ordinates.length; ++i) {
            if (!Double.isInfinite(this.ordinates[i])) continue;
            return true;
        }
        return false;
    }

    public void setToNull() {
        Arrays.fill(this.ordinates, Double.NaN);
        assert (this.isNull()) : this;
    }

    public boolean isNull() {
        for (int i = 0; i < this.ordinates.length; ++i) {
            if (Double.isNaN(this.ordinates[i])) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    public boolean isEmpty() {
        int n = this.ordinates.length / 2;
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (this.ordinates[i] < this.ordinates[i + n]) continue;
            return true;
        }
        assert (!this.isNull()) : this;
        return false;
    }

    private static boolean equalsIgnoreMetadata(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        return coordinateReferenceSystem == null || coordinateReferenceSystem2 == null || CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2);
    }

    public void add(DirectPosition directPosition) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("position", directPosition);
        int n = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("position", directPosition.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, directPosition.getCoordinateReferenceSystem())) : directPosition;
        for (int i = 0; i < n; ++i) {
            double d = directPosition.getOrdinate(i);
            if (d < this.ordinates[i]) {
                this.ordinates[i] = d;
            }
            if (!(d > this.ordinates[i + n])) continue;
            this.ordinates[i + n] = d;
        }
        assert (this.isEmpty() || this.contains(directPosition));
    }

    public void add(Envelope envelope) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        int n = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < n; ++i) {
            double d = envelope.getMinimum(i);
            double d2 = envelope.getMaximum(i);
            if (d < this.ordinates[i]) {
                this.ordinates[i] = d;
            }
            if (!(d2 > this.ordinates[i + n])) continue;
            this.ordinates[i + n] = d2;
        }
        assert (this.isEmpty() || this.contains(envelope, true));
    }

    public boolean contains(DirectPosition directPosition) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("position", directPosition);
        int n = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("point", directPosition.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, directPosition.getCoordinateReferenceSystem())) : directPosition;
        for (int i = 0; i < n; ++i) {
            double d = directPosition.getOrdinate(i);
            if (!(d >= this.ordinates[i])) {
                return false;
            }
            if (d <= this.ordinates[i + n]) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Envelope envelope, boolean bl) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        int n = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < n; ++i) {
            double d = envelope.getMinimum(i);
            double d2 = this.ordinates[i];
            if (!(!bl ? d > d2 : d >= d2)) {
                return false;
            }
            d = envelope.getMaximum(i);
            d2 = this.ordinates[i + n];
            if (!bl ? d < d2 : d <= d2) continue;
            return false;
        }
        assert (this.intersects(envelope, bl));
        return true;
    }

    public boolean intersects(Envelope envelope, boolean bl) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        int n = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < n; ++i) {
            double d = envelope.getMaximum(i);
            double d2 = this.ordinates[i];
            if (!(!bl ? d > d2 : d >= d2)) {
                return false;
            }
            d = envelope.getMinimum(i);
            d2 = this.ordinates[i + n];
            if (!bl ? d < d2 : d <= d2) continue;
            return false;
        }
        return true;
    }

    public void intersect(Envelope envelope) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        int n = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = Math.max(this.ordinates[i], envelope.getMinimum(i));
            if (d2 > (d = Math.min(this.ordinates[i + n], envelope.getMaximum(i)))) {
                d2 = d = 0.5 * (d2 + d);
            }
            this.ordinates[i] = d2;
            this.ordinates[i + n] = d;
        }
    }

    public GeneralEnvelope getSubEnvelope(int n, int n2) throws IndexOutOfBoundsException {
        int n3 = this.ordinates.length / 2;
        int n4 = n2 - n;
        if (n < 0 || n > n3) {
            throw new IndexOutOfBoundsException(Errors.format(63, "lower", n));
        }
        if (n4 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Errors.format(63, "upper", n2));
        }
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(n4);
        System.arraycopy(this.ordinates, n, generalEnvelope.ordinates, 0, n4);
        System.arraycopy(this.ordinates, n + n3, generalEnvelope.ordinates, n4, n4);
        return generalEnvelope;
    }

    public GeneralEnvelope getReducedEnvelope(int n, int n2) throws IndexOutOfBoundsException {
        int n3 = this.ordinates.length / 2;
        int n4 = n2 - n;
        if (n < 0 || n > n3) {
            throw new IndexOutOfBoundsException(Errors.format(63, "lower", n));
        }
        if (n4 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Errors.format(63, "upper", n2));
        }
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(n3 - n4);
        System.arraycopy(this.ordinates, 0, generalEnvelope.ordinates, 0, n);
        System.arraycopy(this.ordinates, n, generalEnvelope.ordinates, n2, n3 - n2);
        return generalEnvelope;
    }

    public Rectangle2D toRectangle2D() throws IllegalStateException {
        if (this.ordinates.length == 4) {
            return XRectangle2D.createFromExtremums(this.ordinates[0], this.ordinates[1], this.ordinates[2], this.ordinates[3]);
        }
        throw new IllegalStateException(Errors.format(136, this.getDimension()));
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            n += this.crs.hashCode();
        }
        assert (n == super.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)object;
            return Arrays.equals(this.ordinates, generalEnvelope.ordinates) && Utilities.equals(this.crs, generalEnvelope.crs);
        }
        return false;
    }

    public boolean equals(Envelope envelope, double d, boolean bl) {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        int n = this.getDimension();
        if (envelope.getDimension() != n) {
            return false;
        }
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < n; ++i) {
            double d2;
            d2 = bl ? ((d2 = Math.max(this.getSpan(i), envelope.getSpan(i))) > 0.0 && d2 < Double.POSITIVE_INFINITY ? d2 * d : d) : d;
            if (Math.abs(this.getMinimum(i) - envelope.getMinimum(i)) <= d2 && Math.abs(this.getMaximum(i) - envelope.getMaximum(i)) <= d2) continue;
            return false;
        }
        return true;
    }

    @Override
    public GeneralEnvelope clone() {
        try {
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)super.clone();
            generalEnvelope.ordinates = (double[])generalEnvelope.ordinates.clone();
            return generalEnvelope;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }
}

