/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import org.geotoolkit.geometry.AbstractEnvelope;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImmutableEnvelope
extends AbstractEnvelope {
    private final CoordinateReferenceSystem crs;
    private final double[] ordinates;

    public ImmutableEnvelope(Envelope envelope) {
        this.crs = envelope.getCoordinateReferenceSystem();
        int n = envelope.getDimension();
        this.ordinates = new double[2 * n];
        for (int i = 0; i < n; ++i) {
            this.ordinates[i] = envelope.getMinimum(i);
            this.ordinates[i + n] = envelope.getMaximum(i);
        }
    }

    public ImmutableEnvelope(CoordinateReferenceSystem coordinateReferenceSystem, double d, double d2, double d3, double d4) {
        int n;
        this.crs = coordinateReferenceSystem;
        if (coordinateReferenceSystem != null && (n = coordinateReferenceSystem.getCoordinateSystem().getDimension()) != 2) {
            throw new MismatchedDimensionException(Errors.format(101, "crs", n, 2));
        }
        this.ordinates = new double[]{d, d3, d2, d4};
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public int getDimension() {
        return this.ordinates.length / 2;
    }

    @Override
    public double getMinimum(int n) throws IndexOutOfBoundsException {
        if (n >= 0 && n < this.ordinates.length / 2) {
            return this.ordinates[n];
        }
        throw new IndexOutOfBoundsException(Errors.format(85, n));
    }

    @Override
    public double getMaximum(int n) throws IndexOutOfBoundsException {
        if (n >= 0 && n < this.ordinates.length / 2) {
            return this.ordinates[n + this.ordinates.length / 2];
        }
        throw new IndexOutOfBoundsException(Errors.format(85, n));
    }

    @Override
    public double getMedian(int n) throws IndexOutOfBoundsException {
        return (this.ordinates[n] + this.ordinates[n + this.ordinates.length / 2]) / 2.0;
    }

    @Override
    public double getSpan(int n) throws IndexOutOfBoundsException {
        return this.ordinates[n + this.ordinates.length / 2] - this.ordinates[n];
    }
}

