/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gui.swing.tree;

import java.io.Console;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geotoolkit.gui.swing.tree.DefaultMutableTreeNode;
import org.geotoolkit.gui.swing.tree.MutableTreeNode;
import org.geotoolkit.gui.swing.tree.NamedTreeNode;
import org.geotoolkit.gui.swing.tree.TreeNode;
import org.geotoolkit.gui.swing.tree.TreeNodeFilter;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.io.LineReader;
import org.geotoolkit.io.LineReaders;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.XArrays;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Trees {
    private Trees() {
    }

    public static Object getUserObject(javax.swing.tree.TreeNode treeNode) {
        if (treeNode instanceof TreeNode) {
            return ((TreeNode)treeNode).getUserObject();
        }
        if (treeNode instanceof javax.swing.tree.DefaultMutableTreeNode) {
            return ((javax.swing.tree.DefaultMutableTreeNode)treeNode).getUserObject();
        }
        return null;
    }

    public static TreePath[] getPathsToUserObject(TreeModel treeModel, Object object) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(8);
        Object[] objectArray = new Object[8];
        objectArray[0] = treeModel.getRoot();
        Trees.getPathsToUserObject(treeModel, object, objectArray, 1, arrayList);
        return arrayList.toArray(new TreePath[arrayList.size()]);
    }

    private static Object[] getPathsToUserObject(TreeModel treeModel, Object object, Object[] objectArray, int n, List<TreePath> list) {
        Object object2;
        Object object3 = objectArray[n - 1];
        if (object3 instanceof TreeNode && ((object2 = ((TreeNode)object3).getUserObject()) == object || object != null && object.equals(object2))) {
            list.add(new TreePath(XArrays.resize(objectArray, n)));
        }
        int n2 = treeModel.getChildCount(object3);
        for (int i = 0; i < n2; ++i) {
            if (n >= objectArray.length) {
                objectArray = Arrays.copyOf(objectArray, n << 1);
            }
            objectArray[n] = treeModel.getChild(object3, i);
            objectArray = Trees.getPathsToUserObject(treeModel, object, objectArray, n + 1, list);
        }
        return objectArray;
    }

    public static MutableTreeNode xmlToSwing(Node node) {
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        if (string2 != null) {
            string = string + "=\"" + string2 + '\"';
        }
        NamedTreeNode namedTreeNode = new NamedTreeNode(string, node, true);
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2 == null) continue;
            string = node2.getNodeName() + "=\"" + node2.getNodeValue() + '\"';
            namedTreeNode.add(new NamedTreeNode(string, node2, false));
        }
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            namedTreeNode.add(Trees.xmlToSwing(node3));
        }
        return namedTreeNode;
    }

    public static MutableTreeNode copy(javax.swing.tree.TreeNode treeNode) {
        return Trees.copy(treeNode, null);
    }

    public static MutableTreeNode copy(javax.swing.tree.TreeNode treeNode, TreeNodeFilter treeNodeFilter) {
        if (treeNode == null || treeNodeFilter != null && !treeNodeFilter.accept(treeNode)) {
            return null;
        }
        String string = treeNode.toString();
        Object object = Trees.getUserObject(treeNode);
        if (treeNodeFilter != null) {
            object = treeNodeFilter.convertUserObject(treeNode, object);
        }
        boolean bl = treeNode.getAllowsChildren();
        DefaultMutableTreeNode defaultMutableTreeNode = object == null || object == string ? new DefaultMutableTreeNode(string, bl) : new NamedTreeNode(string, object, bl);
        Enumeration<? extends javax.swing.tree.TreeNode> enumeration = treeNode.children();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                MutableTreeNode mutableTreeNode = Trees.copy(enumeration.nextElement(), treeNodeFilter);
                if (mutableTreeNode == null) continue;
                defaultMutableTreeNode.add(mutableTreeNode);
            }
        }
        return defaultMutableTreeNode;
    }

    public static MutableTreeNode parse(String string) throws IllegalArgumentException {
        try {
            return Trees.parse(LineReaders.wrap(string));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getLocalizedMessage());
        }
    }

    public static MutableTreeNode parse(LineReader lineReader) throws IOException {
        String string;
        int n = 0;
        int[] nArray = new int[16];
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        while ((string = lineReader.readLine()) != null) {
            int n2;
            boolean bl = false;
            int n3 = string.length();
            for (n2 = 0; n2 < n3; ++n2) {
                char c = string.charAt(n2);
                if (Character.isSpaceChar(c)) continue;
                bl = true;
                if ("\u2500\u2502\u2514\u251c".indexOf(c) < 0) break;
            }
            if (!bl) continue;
            while (n2 != 0 && Character.isSpaceChar(string.charAt(n2 - 1))) {
                --n2;
            }
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string.substring(n2).trim());
            if (defaultMutableTreeNode == null) {
                nArray[0] = n2;
                defaultMutableTreeNode = defaultMutableTreeNode3;
            } else {
                int n4;
                while (n2 < (n4 = nArray[n])) {
                    if (--n < 0) {
                        throw new ContentFormatException(Errors.format(111, defaultMutableTreeNode3));
                    }
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                }
                if (n2 == n4) {
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                    if (defaultMutableTreeNode4 == null) {
                        throw new ContentFormatException(Errors.format(111, defaultMutableTreeNode3));
                    }
                    defaultMutableTreeNode4.add(defaultMutableTreeNode3);
                } else if (n2 > n4) {
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    if (++n == nArray.length) {
                        nArray = Arrays.copyOf(nArray, n * 2);
                    }
                    nArray[n] = n2;
                }
            }
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        }
        return defaultMutableTreeNode;
    }

    private static boolean[] format(TreeModel treeModel, Object object, Appendable appendable, int n, boolean[] blArray, String string) throws IOException {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 != n - 1) {
                appendable.append(blArray[n2] ? (char)'\u00a0' : '\u2502').append("\u00a0\u00a0\u00a0");
                continue;
            }
            appendable.append(blArray[n2] ? (char)'\u2514' : '\u251c').append("\u2500\u2500\u2500");
        }
        appendable.append(String.valueOf(object)).append(string);
        if (n >= blArray.length) {
            blArray = Arrays.copyOf(blArray, n * 2);
        }
        n2 = treeModel.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            blArray[n] = i == n2 - 1;
            blArray = Trees.format(treeModel, treeModel.getChild(object, i), appendable, n + 1, blArray, string);
        }
        return blArray;
    }

    public static void format(TreeModel treeModel, Appendable appendable, String string) throws IOException {
        Object object = treeModel.getRoot();
        if (object != null) {
            if (string == null) {
                string = System.getProperty("line.separator", "\n");
            }
            Trees.format(treeModel, object, appendable, 0, new boolean[64], string);
        }
    }

    public static void format(javax.swing.tree.TreeNode treeNode, Appendable appendable, String string) throws IOException {
        Trees.format(new DefaultTreeModel(treeNode, true), appendable, string);
    }

    public static String toString(TreeModel treeModel) {
        Object object = treeModel.getRoot();
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator", "\n");
        try {
            Trees.format(treeModel, object, stringBuilder, 0, new boolean[64], string);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder.toString();
    }

    public static String toString(javax.swing.tree.TreeNode treeNode) {
        return Trees.toString(new DefaultTreeModel(treeNode, true));
    }

    public static void print(TreeModel treeModel) {
        Trees.print(Trees.toString(treeModel));
    }

    public static void print(javax.swing.tree.TreeNode treeNode) {
        Trees.print(Trees.toString(treeNode));
    }

    private static void print(String string) {
        Console console = System.console();
        PrintWriter printWriter = console != null ? console.writer() : new PrintWriter(System.out);
        printWriter.println(string);
        printWriter.flush();
    }

    public static void show(javax.swing.tree.TreeNode treeNode, String string) {
        Trees.show(new DefaultTreeModel(treeNode, true), string);
    }

    public static void show(TreeModel treeModel, String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(2);
        jFrame.add(new JScrollPane(new JTree(treeModel)));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

