/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.util.Collection;
import java.util.Iterator;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

public final class Citations {
    private Citations() {
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        InternationalString internationalString = citation2.getTitle();
        Iterator<? extends InternationalString> iterator = null;
        while (true) {
            String string;
            if (Citations.titleMatches(citation, string = internationalString.toString(null))) {
                return true;
            }
            String string2 = ((Object)internationalString).toString();
            if (string2 != string && Citations.titleMatches(citation, string2)) {
                return true;
            }
            if (iterator == null) {
                Collection<? extends InternationalString> collection = citation2.getAlternateTitles();
                if (collection == null) break;
                iterator = collection.iterator();
            }
            if (!iterator.hasNext()) break;
            internationalString = (InternationalString)iterator.next();
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, String string) {
        string = string.trim();
        InternationalString internationalString = citation.getTitle();
        Iterator<? extends InternationalString> iterator = null;
        while (true) {
            String string2;
            if ((string2 = internationalString.toString(null)).trim().equalsIgnoreCase(string)) {
                return true;
            }
            String string3 = ((Object)internationalString).toString();
            if (string3 != string2 && string3.trim().equalsIgnoreCase(string)) {
                return true;
            }
            if (iterator == null) {
                Collection<? extends InternationalString> collection = citation.getAlternateTitles();
                if (collection == null) break;
                iterator = collection.iterator();
            }
            if (!iterator.hasNext()) break;
            internationalString = (InternationalString)iterator.next();
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        if (citation == citation2) {
            return true;
        }
        Iterator<? extends Identifier> iterator = citation2.getIdentifiers().iterator();
        if (!iterator.hasNext()) {
            iterator = citation.getIdentifiers().iterator();
            if (!iterator.hasNext()) {
                return Citations.titleMatches(citation, citation2);
            }
            citation = citation2;
            citation2 = null;
        }
        do {
            String string;
            if (!Citations.identifierMatches(citation, string = iterator.next().getCode().trim())) continue;
            return true;
        } while (iterator.hasNext());
        return false;
    }

    public static boolean identifierMatches(Citation citation, String string) {
        string = string.trim();
        Collection<? extends Identifier> collection = citation.getIdentifiers();
        for (Identifier identifier : collection) {
            String string2 = identifier.getCode().trim();
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        if (collection.isEmpty()) {
            return Citations.titleMatches(citation, string);
        }
        return false;
    }

    public static String getIdentifier(Citation citation) {
        String string = null;
        if (citation != null) {
            for (Identifier identifier : citation.getIdentifiers()) {
                String string2 = identifier.getCode().trim();
                int n = string2.length();
                if (n == 0 || string != null && n >= string.length()) continue;
                string = string2;
            }
            if (string == null) {
                string = String.valueOf(citation.getTitle());
            }
        }
        return string;
    }
}

