/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.opengis.util.CodeList;

public final class CodeLists
implements CodeList.Filter {
    private final String codename;

    private CodeLists(String string) {
        this.codename = string;
    }

    public static String[] identifiers(Class<CodeList<?>> clazz) {
        CodeList[] codeListArray = CodeLists.values(clazz);
        String[] stringArray = new String[codeListArray.length];
        for (int i = 0; i < codeListArray.length; ++i) {
            CodeList codeList = codeListArray[i];
            String string = codeList.identifier();
            if (string == null) {
                string = codeList.name();
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public static <T extends CodeList<?>> T[] values(Class<T> clazz) {
        Object object;
        try {
            object = clazz.getMethod("values", null).invoke(null, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
        catch (Exception exception) {
            object = Array.newInstance(clazz, 0);
        }
        return (CodeList[])object;
    }

    public static <T extends CodeList<T>> T valueOf(Class<T> clazz, String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        try {
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        return CodeList.valueOf(clazz, new CodeLists(string));
    }

    @Override
    public String codename() {
        return this.codename;
    }

    @Override
    public boolean accept(CodeList<?> codeList) {
        for (String string : codeList.names()) {
            if (!CodeLists.matches(string, this.codename)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(String string, String string2) {
        int n = string2.length();
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (!CodeLists.isSignificant(c2)) continue;
            do {
                if (n3 < n) continue;
                return false;
            } while (!CodeLists.isSignificant(c = string2.charAt(n3++)));
            if (c2 == c || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return false;
        }
        while (n3 < n) {
            if (!CodeLists.isSignificant(string2.charAt(n3++))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSignificant(char c) {
        return !Character.isWhitespace(c);
    }
}

