/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;

public abstract class ReferenceQueueConsumer<T>
extends Thread {
    private static final ThreadGroup GROUP = new ThreadGroup(Threads.PARENT, "ReferenceQueueConsumers");
    public final ReferenceQueue<T> queue = new ReferenceQueue();

    protected ReferenceQueueConsumer(String string) {
        super(GROUP, string);
        this.setPriority(8);
        this.setDaemon(true);
    }

    protected abstract void process(Reference<? extends T> var1);

    @Override
    public final void run() {
        ReferenceQueue<T> referenceQueue;
        while ((referenceQueue = this.queue) != null) {
            Reference<T> reference;
            try {
                reference = referenceQueue.remove();
                if (reference == null) {
                    ReferenceQueueConsumer.sleep(15000L);
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            try {
                this.process(reference);
            }
            catch (Exception exception) {
                Logging.unexpectedException(this.getClass(), "run", exception);
            }
            catch (AssertionError assertionError) {
                Logging.unexpectedException(this.getClass(), "run", (Throwable)((Object)assertionError));
            }
        }
        Logging.getLogger(this.getClass()).severe(Classes.getShortClassName(this) + " daemon stopped.");
    }
}

