/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.geotoolkit.internal.InternalWindowListener;
import org.geotoolkit.internal.OS;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.logging.Logging;

public final class SwingUtilities {
    public static final ThreadGroup WORKER_THREADS = new ThreadGroup(Threads.PARENT, "SwingWorkers");

    private SwingUtilities() {
    }

    public static void setLookAndFeel(Class<?> clazz, String string) {
        if (!OS.MAC_OS.equals((Object)OS.current())) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            }
            catch (Exception exception) {
                Logging.recoverableException(clazz, string, exception);
            }
        }
    }

    public static Component toFrame(Component component, JComponent jComponent, String string, WindowListener windowListener) {
        while (component != null) {
            if (component == jComponent) {
                throw new IllegalArgumentException();
            }
            if (component instanceof JDesktopPane) {
                JInternalFrame jInternalFrame = new JInternalFrame(string, true, true, true, true);
                jInternalFrame.setDefaultCloseOperation(2);
                jInternalFrame.addInternalFrameListener(InternalWindowListener.wrap(windowListener));
                ((JDesktopPane)component).add(jInternalFrame);
                jInternalFrame.getContentPane().add(jComponent);
                jInternalFrame.pack();
                return jInternalFrame;
            }
            if (component instanceof Frame) {
                JDialog jDialog = new JDialog((Frame)component, string);
                jDialog.setDefaultCloseOperation(2);
                jDialog.addWindowListener(windowListener);
                jDialog.getContentPane().add(jComponent);
                jDialog.pack();
                return jDialog;
            }
            if (component instanceof Dialog) {
                JDialog jDialog = new JDialog((Dialog)component, string);
                jDialog.setDefaultCloseOperation(2);
                jDialog.addWindowListener(windowListener);
                jDialog.getContentPane().add(jComponent);
                jDialog.pack();
                return jDialog;
            }
            component = component.getParent();
        }
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(2);
        jFrame.addWindowListener(windowListener);
        jFrame.getContentPane().add(jComponent);
        jFrame.pack();
        return jFrame;
    }

    public static void setTitle(Component component, String string) {
        while (component != null) {
            if (component instanceof JInternalFrame) {
                ((JInternalFrame)component).setTitle(string);
            }
            if (component instanceof Frame) {
                ((Frame)component).setTitle(string);
                return;
            }
            if (!(component instanceof Dialog)) continue;
            ((Dialog)component).setTitle(string);
            return;
        }
    }

    public static boolean showOptionDialog(Component component, Object object, String string) {
        return SwingUtilities.showOptionDialog(component, object, string, null);
    }

    public static boolean showOptionDialog(final Component component, final Object object, final String string, final ActionListener actionListener) {
        if (!EventQueue.isDispatchThread()) {
            final boolean[] blArray = new boolean[1];
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    blArray[0] = SwingUtilities.showOptionDialog(component, object, string, actionListener);
                }
            });
            return blArray[0];
        }
        Object[] objectArray = null;
        Object object2 = null;
        int n = 0;
        if (actionListener != null) {
            JButton jButton;
            Vocabulary vocabulary = Vocabulary.getResources(component != null ? component.getLocale() : null);
            if (actionListener instanceof Action) {
                jButton = new JButton((Action)actionListener);
            } else {
                jButton = new JButton(vocabulary.getString(223));
                jButton.addActionListener(actionListener);
            }
            objectArray = new Object[]{vocabulary.getString(191), vocabulary.getString(19), jButton};
            n = 0;
            object2 = objectArray[0];
        }
        int n2 = JOptionPane.getDesktopPaneForComponent(component) != null ? JOptionPane.showInternalOptionDialog(component, object, string, 2, -1, null, objectArray, object2) : JOptionPane.showOptionDialog(component, object, string, 2, -1, null, objectArray, object2);
        return n2 == n;
    }

    public static void showMessageDialog(final Component component, final Object object, final String string, final int n) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.showMessageDialog(component, object, string, n);
                }
            });
            return;
        }
        if (JOptionPane.getDesktopPaneForComponent(component) != null) {
            JOptionPane.showInternalMessageDialog(component, object, string, n);
        } else {
            JOptionPane.showMessageDialog(component, object, string, n);
        }
    }

    public static boolean showConfirmDialog(final Component component, final Object object, final String string, final int n) {
        if (!EventQueue.isDispatchThread()) {
            final boolean[] blArray = new boolean[1];
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    blArray[0] = SwingUtilities.showConfirmDialog(component, object, string, n);
                }
            });
            return blArray[0];
        }
        int n2 = JOptionPane.getDesktopPaneForComponent(component) != null ? JOptionPane.showInternalConfirmDialog(component, object, string, 0, n) : JOptionPane.showConfirmDialog(component, object, string, 0, n);
        return n2 == 0;
    }

    public static TableCellRenderer setupAsRowHeader(JTable jTable) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        Color color = jTableHeader.getBackground();
        Color color2 = jTableHeader.getForeground();
        if (color == null || color.equals(jTable.getBackground())) {
            color = SystemColor.control;
            color2 = SystemColor.controlText;
        }
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setBackground(color);
        defaultTableCellRenderer.setForeground(color2);
        defaultTableCellRenderer.setHorizontalAlignment(4);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setPreferredWidth(60);
        jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
        jTable.setSelectionMode(0);
        jTable.setCellSelectionEnabled(false);
        return defaultTableCellRenderer;
    }

    public static void remove(DefaultListModel defaultListModel, int[] nArray) {
        int n = nArray.length;
        if (n != 0) {
            int n2;
            Arrays.sort(nArray);
            int n3 = n2 = nArray[--n];
            while (n != 0) {
                int n4;
                if ((n4 = nArray[--n]) != n3 - 1) {
                    if (n3 == n2) {
                        defaultListModel.remove(n3);
                    } else {
                        defaultListModel.removeRange(n3, n2);
                    }
                    n2 = n4;
                }
                n3 = n4;
            }
            if (n3 == n2) {
                defaultListModel.remove(n3);
            } else {
                defaultListModel.removeRange(n3, n2);
            }
        }
    }

    public static Locale getLocale(Component component) {
        if (component != null) {
            try {
                return component.getLocale();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        return JComponent.getDefaultLocale();
    }

    public static void invokeAndWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new UndeclaredThrowableException(throwable, throwable.getLocalizedMessage());
            }
        }
    }

    static {
        WORKER_THREADS.setMaxPriority(3);
    }
}

