/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.resources.Errors;

public final class IOUtilities {
    private IOUtilities() {
    }

    public static File commonParent(File file, File file2) {
        while (file != null) {
            for (File file3 = file2; file3 != null; file3 = file3.getParentFile()) {
                if (!file.equals(file3)) continue;
                return file;
            }
            file = file.getParentFile();
        }
        return null;
    }

    public static Object toFileOrURL(String string) throws MalformedURLException {
        int n;
        if (string.indexOf(63) < 0 && string.indexOf(35) < 0 && ((n = string.indexOf(58)) < 0 || n == 1 && Character.isLetter(string.charAt(0)) && !string.regionMatches(2, "//", 0, 2))) {
            return new File(string);
        }
        URL uRL = new URL(string);
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            return new File(uRL.getFile());
        }
        return uRL;
    }

    public static String extension(Object object) {
        int n;
        String string;
        if (object instanceof File) {
            string = ((File)object).getName();
            n = 0;
        } else {
            string = object instanceof URL ? ((URL)object).getPath() : (object instanceof URI ? ((URI)object).getPath() : object.toString());
            n = string.lastIndexOf(47);
        }
        int n2 = string.lastIndexOf(46) + 1;
        return n2 > n ? string.substring(n2).trim() : "";
    }

    public static InputStream open(Object object) throws IOException, ClassCastException {
        if (object instanceof CharSequence) {
            object = IOUtilities.toFileOrURL(object.toString());
        }
        if (object instanceof File) {
            return new FileInputStream((File)object);
        }
        if (object instanceof URL) {
            return ((URL)object).openStream();
        }
        return ((URI)object).toURL().openStream();
    }

    public static LineNumberReader openLatin(Object object) throws IOException, ClassCastException {
        return new LineNumberReader(new InputStreamReader(IOUtilities.open(object), "ISO-8859-1"));
    }

    public static void readMatrixRow(BufferedReader bufferedReader, double[] dArray, int n, int n2) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new EOFException(Errors.format(52));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        for (int i = 0; i < n2; ++i) {
            double d;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ContentFormatException(Errors.format(94, i, n2));
            }
            String string2 = stringTokenizer.nextToken();
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ContentFormatException(Errors.format(202, string2), numberFormatException);
            }
            dArray[n + i] = d;
        }
        if (stringTokenizer.hasMoreElements()) {
            throw new ContentFormatException(Errors.format(93, n2 + stringTokenizer.countTokens(), n2, stringTokenizer.nextToken()));
        }
    }

    public static void readMatrixRow(BufferedReader bufferedReader, float[] fArray, int n, int n2) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new EOFException(Errors.format(52));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        for (int i = 0; i < n2; ++i) {
            float f;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ContentFormatException(Errors.format(94, i, n2));
            }
            String string2 = stringTokenizer.nextToken();
            try {
                f = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ContentFormatException(Errors.format(202, string2), numberFormatException);
            }
            fArray[n + i] = f;
        }
        if (stringTokenizer.hasMoreElements()) {
            throw new ContentFormatException(Errors.format(93, n2 + stringTokenizer.countTokens(), n2, stringTokenizer.nextToken()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream inputStream, File file) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            byte[] byArray = new byte[4096];
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                File file2 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (file2.isDirectory() || file2.mkdir()) continue;
                    throw new IOException(Errors.format(23, file2));
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while ((n = zipInputStream.read(byArray)) >= 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)fileOutputStream).close();
                long l = zipEntry.getTime();
                if (l >= 0L) {
                    file2.setLastModified(l);
                }
                zipInputStream.closeEntry();
            }
        }
        finally {
            zipInputStream.close();
        }
    }
}

