/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.prefs.Preferences;
import org.geotoolkit.internal.OS;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.Logging;

public enum Installation {
    ROOT_DIRECTORY("org/geotoolkit", "Root directory", null),
    NADCON("org/geotoolkit/referencing/operation/transform", "Grid location", "NADCON"),
    EPSG("org/geotoolkit/referencing/factory", "EPSG", "EPSG");

    private final String node;
    private final String key;
    private final String directory;
    private static final File DEFAULT_ROOT;

    private Installation(String string2, String string3, String string4) {
        this.node = string2;
        this.key = string3;
        this.directory = string4;
    }

    private Preferences preference(boolean bl) {
        return (bl ? Preferences.userRoot() : Preferences.systemRoot()).node(this.node);
    }

    public final void set(boolean bl, String string) {
        Preferences preferences = this.preference(bl);
        if (string != null) {
            preferences.put(this.key, string);
        } else {
            preferences.remove(this.key);
        }
        if (!bl) {
            this.preference(true).remove(this.key);
        }
    }

    public final String get(boolean bl) {
        return this.preference(bl).get(this.key, null);
    }

    private static File root() {
        try {
            String string = System.getProperty("user.home");
            if (string != null) {
                File file = new File(string);
                String string2 = ".geotoolkit";
                OS oS = OS.current();
                switch (oS) {
                    case WINDOWS: {
                        file = new File(file, "Application Data");
                        string2 = "Geotoolkit";
                        break;
                    }
                    case MAC_OS: {
                        file = new File(file, "Library");
                        string2 = "Geotoolkit";
                    }
                }
                if (file.isDirectory() && (!oS.unix || file.canWrite())) {
                    return new File(file, string2);
                }
            }
        }
        catch (SecurityException securityException) {
            Logging.getLogger("org.geotoolkit").warning(securityException.toString());
        }
        return new File(System.getProperty("java.io.tmpdir"), "Geotoolkit");
    }

    public File directory(boolean bl) {
        if (bl) {
            boolean bl2 = true;
            do {
                String string;
                if ((string = this.get(bl2)) == null) continue;
                return new File(string);
            } while (!(bl2 = !bl2));
        }
        if (this.directory != null) {
            return new File(ROOT_DIRECTORY.directory(true), this.directory);
        }
        return DEFAULT_ROOT;
    }

    public File validDirectory(boolean bl) throws IOException {
        File file = this.directory(bl);
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException(Errors.format(24, file));
        }
        return file;
    }

    public Object toFileOrURL(Class<?> clazz, String string) throws IOException {
        Object object = IOUtilities.toFileOrURL(string);
        if (object instanceof URL) {
            return (URL)object;
        }
        File file = (File)object;
        if (!file.isAbsolute()) {
            URL uRL;
            if (this.directory != null && file.getParent() == null && (uRL = clazz.getResource(this.directory + '/' + file.getPath())) != null) {
                return uRL;
            }
            file = new File(this.directory(true), file.getPath());
        }
        return file;
    }

    public boolean exists(Class<?> clazz, String string) throws IOException {
        Object object = this.toFileOrURL(clazz, string);
        if (object instanceof File) {
            return ((File)object).isFile();
        }
        return object != null;
    }

    static {
        DEFAULT_ROOT = Installation.root();
    }
}

