/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.io;

import java.io.File;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.util.HashMap;
import java.util.Map;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.internal.io.TemporaryFileCleaner;

public final class TemporaryFile
extends PhantomReference<File> {
    private static final Map<String, TemporaryFile> REFERENCES = new HashMap<String, TemporaryFile>();
    private final String path;

    private TemporaryFile(File file) {
        super(file, TemporaryFileCleaner.INSTANCE.queue);
        this.path = file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempFile(String string, String string2, File file) throws IOException {
        File file2 = File.createTempFile(string, string2, file);
        TemporaryFile temporaryFile = new TemporaryFile(file2);
        Map<String, TemporaryFile> map = REFERENCES;
        synchronized (map) {
            if (REFERENCES.put(temporaryFile.path, temporaryFile) != null) {
                throw new AssertionError(temporaryFile);
            }
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(File file) {
        Map<String, TemporaryFile> map = REFERENCES;
        synchronized (map) {
            TemporaryFile temporaryFile = REFERENCES.remove(file.getPath());
            if (temporaryFile != null) {
                temporaryFile.clear();
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean delete() {
        Map<String, TemporaryFile> map = REFERENCES;
        synchronized (map) {
            if (REFERENCES.remove(this.path) == this) {
                return new File(this.path).delete();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean deleteAll() {
        boolean bl = false;
        Map<String, TemporaryFile> map = REFERENCES;
        if (map != null) {
            Map<String, TemporaryFile> map2 = map;
            synchronized (map2) {
                for (TemporaryFile temporaryFile : map.values()) {
                    bl |= new File(temporaryFile.path).delete();
                    temporaryFile.clear();
                }
                map.clear();
            }
        }
        return bl;
    }

    public String toString() {
        return this.path;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(Threads.SHUTDOWN_HOOKS, "TemporaryFileCleaner"){

            @Override
            public void run() {
                while (TemporaryFile.deleteAll()) {
                    Thread.yield();
                }
            }
        });
    }
}

