/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.io;

import java.io.File;
import java.lang.ref.Reference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotoolkit.internal.ReferenceQueueConsumer;
import org.geotoolkit.internal.io.TemporaryFile;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.logging.Logging;

final class TemporaryFileCleaner
extends ReferenceQueueConsumer<File> {
    static final TemporaryFileCleaner INSTANCE = new TemporaryFileCleaner();

    private TemporaryFileCleaner() {
        super("TemporaryFileCleaner");
        this.setPriority(5);
    }

    @Override
    protected void process(Reference<? extends File> reference) {
        TemporaryFile temporaryFile = (TemporaryFile)reference;
        if (temporaryFile.delete()) {
            LogRecord logRecord = Loggings.format(Level.WARNING, 57, temporaryFile);
            logRecord.setSourceClassName(TemporaryFile.class.getName());
            logRecord.setSourceMethodName("delete");
            Logging.log(TemporaryFile.class, logRecord);
        }
    }

    static {
        INSTANCE.start();
    }
}

