/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.resources.Errors;

public final class XmlUtilities {
    private static DatatypeFactory factory;

    private XmlUtilities() {
    }

    private static synchronized DatatypeFactory getDatatypeFactory() throws FactoryNotFoundException {
        if (factory == null) {
            try {
                factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new FactoryNotFoundException(Errors.format(53, DatatypeFactory.class), datatypeConfigurationException);
            }
        }
        return factory;
    }

    public static XMLGregorianCalendar toXML(Date date) {
        if (date != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return XmlUtilities.getDatatypeFactory().newXMLGregorianCalendar(gregorianCalendar);
        }
        return null;
    }

    public static Date toDate(XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar != null) {
            return xMLGregorianCalendar.toGregorianCalendar().getTime();
        }
        return null;
    }
}

