/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb.metadata;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.geotoolkit.internal.jaxb.metadata.FreeText;
import org.geotoolkit.internal.jaxb.metadata.LocalisedCharacterString;
import org.geotoolkit.internal.jaxb.metadata.TextGroup;
import org.geotoolkit.internal.jaxb.text.CharacterString;
import org.geotoolkit.util.DefaultInternationalString;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

public class InternationalStringAdapter
extends XmlAdapter<CharacterString, InternationalString> {
    public final InternationalString unmarshal(CharacterString characterString) {
        if (characterString != null) {
            if (characterString instanceof FreeText) {
                FreeText freeText = (FreeText)characterString;
                TextGroup textGroup = freeText.textGroup;
                if (textGroup == null) {
                    return null;
                }
                DefaultInternationalString defaultInternationalString = new DefaultInternationalString();
                for (LocalisedCharacterString localisedCharacterString : textGroup.localised) {
                    defaultInternationalString.add(localisedCharacterString.locale, localisedCharacterString.text);
                }
                return defaultInternationalString;
            }
            String string = characterString.toString();
            if (string != null && (string = string.trim()).length() != 0) {
                return new SimpleInternationalString(string);
            }
        }
        return null;
    }

    public CharacterString marshal(InternationalString internationalString) {
        if (internationalString != null) {
            if (internationalString instanceof DefaultInternationalString) {
                return new FreeText((DefaultInternationalString)internationalString);
            }
            String string = ((Object)internationalString).toString();
            if (string != null && (string = string.trim()).length() != 0) {
                return new CharacterString(string);
            }
        }
        return null;
    }
}

