/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb.referencing;

import java.util.Date;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.xml.bind.annotation.XmlElement;
import org.geotoolkit.internal.jaxb.XmlUtilities;
import org.geotoolkit.internal.jaxb.metadata.MetadataAdapter;
import org.geotoolkit.internal.jaxb.referencing.TimePeriod;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.Logging;
import org.opengis.temporal.Period;
import org.opengis.temporal.TemporalFactory;
import org.opengis.temporal.TemporalPrimitive;

public final class TemporalPrimitiveAdapter
extends MetadataAdapter<TemporalPrimitiveAdapter, TemporalPrimitive> {
    private static final TemporalFactory factory;

    public TemporalPrimitiveAdapter() {
    }

    private TemporalPrimitiveAdapter(TemporalPrimitive temporalPrimitive) {
        super(temporalPrimitive);
    }

    @Override
    protected TemporalPrimitiveAdapter wrap(TemporalPrimitive temporalPrimitive) {
        return new TemporalPrimitiveAdapter(temporalPrimitive);
    }

    @XmlElement(name="TimePeriod")
    public TimePeriod getTimePeriod() {
        TemporalPrimitive temporalPrimitive = (TemporalPrimitive)this.metadata;
        if (temporalPrimitive instanceof Period) {
            return new TimePeriod((Period)temporalPrimitive);
        }
        return null;
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.metadata = null;
        if (timePeriod != null) {
            Date date = XmlUtilities.toDate(TimePeriod.select(timePeriod.beginPosition, timePeriod.begin));
            Date date2 = XmlUtilities.toDate(TimePeriod.select(timePeriod.endPosition, timePeriod.end));
            if (date != null && date2 != null) {
                if (date2.before(date)) {
                    LogRecord logRecord = Errors.getResources(null).getLogRecord(Level.WARNING, 13, date, date2);
                    logRecord.setSourceClassName(TemporalPrimitive.class.getName());
                    logRecord.setSourceMethodName("setTimePeriod");
                    Logging.getLogger("org.geotoolkit.xml").log(logRecord);
                    return;
                }
                this.metadata = factory.createPeriod(factory.createInstant(factory.createPosition(date)), factory.createInstant(factory.createPosition(date2)));
            }
        }
    }

    static {
        Iterator<TemporalFactory> iterator = ServiceLoader.load(TemporalFactory.class).iterator();
        factory = iterator.hasNext() ? iterator.next() : null;
    }
}

