/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb.referencing;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.geotoolkit.internal.jaxb.XmlUtilities;
import org.geotoolkit.internal.jaxb.referencing.TimeInstant;
import org.geotoolkit.internal.jaxb.referencing.TimeInstantPropertyType;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;

@XmlType(name="TimePeriodType", propOrder={"beginPosition", "endPosition", "begin", "end"}, namespace="http://www.isotc211.org/2005/gmd")
public final class TimePeriod {
    @XmlElement(namespace="http://www.opengis.net/gml")
    public XMLGregorianCalendar beginPosition;
    @XmlElement(namespace="http://www.opengis.net/gml")
    public XMLGregorianCalendar endPosition;
    @XmlElement(namespace="http://www.opengis.net/gml")
    public TimeInstantPropertyType begin;
    @XmlElement(namespace="http://www.opengis.net/gml")
    public TimeInstantPropertyType end;

    public TimePeriod() {
    }

    public TimePeriod(Period period) {
        this.beginPosition = TimePeriod.toDate(period.getBeginning());
        this.endPosition = TimePeriod.toDate(period.getEnding());
    }

    private static XMLGregorianCalendar toDate(Instant instant) {
        Position position;
        if (instant != null && (position = instant.getPosition()) != null) {
            return XmlUtilities.toXML(position.getDate());
        }
        return null;
    }

    @XmlID
    @XmlAttribute(name="id", required=true, namespace="http://www.opengis.net/gml")
    public String getID() {
        return "extent";
    }

    public String toString() {
        return "TimePeriod[" + TimePeriod.select(this.beginPosition, this.begin) + " ... " + TimePeriod.select(this.endPosition, this.end) + ']';
    }

    static XMLGregorianCalendar select(XMLGregorianCalendar xMLGregorianCalendar, TimeInstantPropertyType timeInstantPropertyType) {
        TimeInstant timeInstant;
        if (xMLGregorianCalendar == null && timeInstantPropertyType != null && (timeInstant = timeInstantPropertyType.timeInstant) != null) {
            xMLGregorianCalendar = timeInstant.timePosition;
        }
        return xMLGregorianCalendar;
    }
}

