/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.awt.geom.Rectangle2D;
import java.text.FieldPosition;
import java.util.Locale;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.measure.AngleFormat;
import org.geotoolkit.measure.Latitude;
import org.geotoolkit.measure.Longitude;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.operation.TransformPathNotFoundException;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.TransformException;

public final class BoundingBoxes
implements ChangeListener {
    private static CoordinateOperationFactory factory;

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        factory = null;
    }

    private BoundingBoxes() {
    }

    private static CoordinateOperationFactory getFactory() {
        if (factory == null) {
            Hints hints = new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
            factory = FactoryFinder.getCoordinateOperationFactory(hints);
        }
        return factory;
    }

    public static void copy(Rectangle2D rectangle2D, CoordinateReferenceSystem coordinateReferenceSystem, DefaultGeographicBoundingBox defaultGeographicBoundingBox) throws TransformException {
        if (coordinateReferenceSystem != null) {
            if ((coordinateReferenceSystem = CRS.getHorizontalCRS(coordinateReferenceSystem)) == null) {
                throw new TransformPathNotFoundException(Errors.format(67));
            }
            GeographicCRS geographicCRS = CRSUtilities.getStandardGeographicCRS2D(coordinateReferenceSystem);
            if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem, geographicCRS)) {
                CoordinateOperation coordinateOperation;
                try {
                    coordinateOperation = BoundingBoxes.getFactory().createOperation(coordinateReferenceSystem, geographicCRS);
                }
                catch (FactoryException factoryException) {
                    throw new TransformPathNotFoundException(factoryException);
                }
                rectangle2D = CRS.transform(coordinateOperation, rectangle2D, null);
            }
        }
        defaultGeographicBoundingBox.setWestBoundLongitude(rectangle2D.getMinX());
        defaultGeographicBoundingBox.setEastBoundLongitude(rectangle2D.getMaxX());
        defaultGeographicBoundingBox.setSouthBoundLatitude(rectangle2D.getMinY());
        defaultGeographicBoundingBox.setNorthBoundLatitude(rectangle2D.getMaxY());
    }

    public static void copy(Envelope envelope, DefaultGeographicBoundingBox defaultGeographicBoundingBox) throws TransformException {
        GeographicCRS geographicCRS;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        if (!(coordinateReferenceSystem == null || BoundingBoxes.startsWith(coordinateReferenceSystem, geographicCRS = CRSUtilities.getStandardGeographicCRS2D(coordinateReferenceSystem)) || BoundingBoxes.startsWith(coordinateReferenceSystem, DefaultGeographicCRS.WGS84) || BoundingBoxes.startsWith(coordinateReferenceSystem, DefaultGeographicCRS.WGS84_3D))) {
            CoordinateOperation coordinateOperation;
            CoordinateOperationFactory coordinateOperationFactory = BoundingBoxes.getFactory();
            try {
                coordinateOperation = coordinateOperationFactory.createOperation(coordinateReferenceSystem, geographicCRS);
            }
            catch (FactoryException factoryException) {
                throw new TransformPathNotFoundException(Errors.format(34, factoryException));
            }
            envelope = CRS.transform(coordinateOperation, envelope);
        }
        defaultGeographicBoundingBox.setWestBoundLongitude(envelope.getMinimum(0));
        defaultGeographicBoundingBox.setEastBoundLongitude(envelope.getMaximum(0));
        defaultGeographicBoundingBox.setSouthBoundLatitude(envelope.getMinimum(1));
        defaultGeographicBoundingBox.setNorthBoundLatitude(envelope.getMaximum(1));
    }

    private static final boolean startsWith(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        int n = coordinateReferenceSystem2.getCoordinateSystem().getDimension();
        return coordinateReferenceSystem.getCoordinateSystem().getDimension() >= n && CRS.equalsIgnoreMetadata(CRSUtilities.getSubCRS(coordinateReferenceSystem, 0, n), coordinateReferenceSystem2);
    }

    public static String toString(GeographicBoundingBox geographicBoundingBox, String string, Locale locale) {
        AngleFormat angleFormat = locale != null ? new AngleFormat(string, locale) : new AngleFormat(string);
        FieldPosition fieldPosition = new FieldPosition(0);
        StringBuffer stringBuffer = new StringBuffer();
        angleFormat.format(new Latitude(geographicBoundingBox.getNorthBoundLatitude()), stringBuffer, fieldPosition).append(", ");
        angleFormat.format(new Longitude(geographicBoundingBox.getWestBoundLongitude()), stringBuffer, fieldPosition).append(" - ");
        angleFormat.format(new Latitude(geographicBoundingBox.getSouthBoundLatitude()), stringBuffer, fieldPosition).append(", ");
        angleFormat.format(new Longitude(geographicBoundingBox.getEastBoundLongitude()), stringBuffer, fieldPosition);
        return stringBuffer.toString();
    }

    static {
        Factories.addChangeListener(new BoundingBoxes());
    }
}

