/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.measure.unit.Unit;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.referencing.datum.DefaultPrimeMeridian;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public final class CRSUtilities {
    private CRSUtilities() {
    }

    public static int dimensionColinearWith(CoordinateSystem coordinateSystem, CoordinateSystemAxis coordinateSystemAxis) {
        int n = -1;
        int n2 = coordinateSystem.getDimension();
        AxisDirection axisDirection = coordinateSystemAxis.getDirection().absolute();
        for (int i = 0; i < n2; ++i) {
            CoordinateSystemAxis coordinateSystemAxis2 = coordinateSystem.getAxis(i);
            if (!axisDirection.equals(coordinateSystemAxis2.getDirection().absolute())) continue;
            n = i;
            if (coordinateSystemAxis.equals(coordinateSystemAxis2)) break;
        }
        return n;
    }

    public static Unit<?> getUnit(CoordinateSystem coordinateSystem) {
        Unit<?> unit = null;
        int n = coordinateSystem.getDimension();
        while (--n >= 0) {
            Unit<?> unit2 = coordinateSystem.getAxis(n).getUnit();
            if (unit2 == null) continue;
            if (unit == null) {
                unit = unit2;
                continue;
            }
            if (unit.equals(unit2)) continue;
            return null;
        }
        return unit;
    }

    private static List<? extends CoordinateReferenceSystem> getComponents(CoordinateReferenceSystem coordinateReferenceSystem) {
        List<CoordinateReferenceSystem> list;
        if (coordinateReferenceSystem instanceof CompoundCRS && !(list = ((CompoundCRS)coordinateReferenceSystem).getComponents()).isEmpty()) {
            return list;
        }
        return null;
    }

    public static int getDimensionOf(CoordinateReferenceSystem coordinateReferenceSystem, Class<? extends CoordinateReferenceSystem> clazz) throws IllegalArgumentException {
        if (clazz.isAssignableFrom(coordinateReferenceSystem.getClass())) {
            return 0;
        }
        List<? extends CoordinateReferenceSystem> list = CRSUtilities.getComponents(coordinateReferenceSystem);
        if (list != null) {
            int n = 0;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : list) {
                int n2 = CRSUtilities.getDimensionOf(coordinateReferenceSystem2, clazz);
                if (n2 >= 0) {
                    return n2 + n;
                }
                n += coordinateReferenceSystem2.getCoordinateSystem().getDimension();
            }
        }
        return -1;
    }

    public static CoordinateReferenceSystem getSubCRS(CoordinateReferenceSystem coordinateReferenceSystem, int n, int n2) {
        int n3 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        if (n < 0 || n > n2 || n2 > n3) {
            throw new IndexOutOfBoundsException(Errors.format(85, n < 0 ? n : n2));
        }
        while (n != 0 || n2 != n3) {
            List<? extends CoordinateReferenceSystem> list = CRSUtilities.getComponents(coordinateReferenceSystem);
            if (list == null) {
                return null;
            }
            Iterator<? extends CoordinateReferenceSystem> iterator = list.iterator();
            while (iterator.hasNext() && n >= (n3 = (coordinateReferenceSystem = iterator.next()).getCoordinateSystem().getDimension())) {
                n -= n3;
                n2 -= n3;
            }
        }
        return coordinateReferenceSystem;
    }

    public static CoordinateReferenceSystem getCRS2D(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        if (coordinateReferenceSystem != null) {
            while (coordinateReferenceSystem.getCoordinateSystem().getDimension() != 2) {
                List<? extends CoordinateReferenceSystem> list = CRSUtilities.getComponents(coordinateReferenceSystem);
                if (list == null) {
                    throw new TransformException(Errors.format(30, coordinateReferenceSystem.getName()));
                }
                coordinateReferenceSystem = list.get(0);
            }
        }
        return coordinateReferenceSystem;
    }

    public static Map<String, ?> changeDimensionInName(IdentifiedObject identifiedObject, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(identifiedObject.getName().getCode());
        int n = stringBuilder.length() - string.length();
        boolean bl = true;
        int n2 = stringBuilder.lastIndexOf(string);
        while (n2 >= 0) {
            if (!(n2 != 0 && Character.isLetterOrDigit(stringBuilder.charAt(n2 - 1)) || n2 != n && Character.isLetterOrDigit(n2 + string.length()))) {
                stringBuilder.replace(n2, n2 + string.length(), string2);
                n2 = stringBuilder.indexOf(". ", n2);
                if (n2 >= 0) {
                    stringBuilder.setLength(n2 + 1);
                }
                bl = false;
                break;
            }
            n2 = stringBuilder.lastIndexOf(string, n2 - 1);
        }
        if (bl) {
            if (stringBuilder.indexOf(" ") >= 0) {
                stringBuilder.append(" (").append(string2).append(')');
            } else {
                stringBuilder.append('_').append(string2);
            }
        }
        return Collections.singletonMap("name", stringBuilder.toString());
    }

    public static Datum getDatum(CoordinateReferenceSystem coordinateReferenceSystem) {
        return coordinateReferenceSystem instanceof SingleCRS ? ((SingleCRS)coordinateReferenceSystem).getDatum() : null;
    }

    public static Ellipsoid getHeadGeoEllipsoid(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (!(coordinateReferenceSystem instanceof GeographicCRS)) {
            List<? extends CoordinateReferenceSystem> list = CRSUtilities.getComponents(coordinateReferenceSystem);
            if (list == null) {
                return null;
            }
            coordinateReferenceSystem = list.get(0);
        }
        return ((GeographicCRS)coordinateReferenceSystem).getDatum().getEllipsoid();
    }

    public static GeographicCRS getStandardGeographicCRS2D(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            coordinateReferenceSystem = ((GeneralDerivedCRS)coordinateReferenceSystem).getBaseCRS();
        }
        if (!(coordinateReferenceSystem instanceof SingleCRS)) {
            return DefaultGeographicCRS.WGS84;
        }
        Datum datum = ((SingleCRS)coordinateReferenceSystem).getDatum();
        if (!(datum instanceof GeodeticDatum)) {
            return DefaultGeographicCRS.WGS84;
        }
        GeodeticDatum geodeticDatum = (GeodeticDatum)datum;
        if (geodeticDatum.getPrimeMeridian().getGreenwichLongitude() != 0.0) {
            geodeticDatum = new DefaultGeodeticDatum(geodeticDatum.getName().getCode(), geodeticDatum.getEllipsoid(), (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
        } else if (coordinateReferenceSystem instanceof GeographicCRS && CRS.equalsIgnoreMetadata(DefaultEllipsoidalCS.GEODETIC_2D, coordinateReferenceSystem.getCoordinateSystem())) {
            return (GeographicCRS)coordinateReferenceSystem;
        }
        return new DefaultGeographicCRS(coordinateReferenceSystem.getName().getCode(), geodeticDatum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
    }

    public static DirectPosition deltaTransform(MathTransform mathTransform, DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        int n;
        int n2 = mathTransform.getSourceDimensions();
        int n3 = mathTransform.getTargetDimensions();
        DirectPosition directPosition3 = new GeneralDirectPosition(n2);
        DirectPosition directPosition4 = new GeneralDirectPosition(n2);
        for (n = 0; n < n2; ++n) {
            double d = directPosition.getOrdinate(n);
            double d2 = directPosition2.getOrdinate(n) * 0.5;
            directPosition3.setOrdinate(n, d - d2);
            directPosition4.setOrdinate(n, d + d2);
        }
        directPosition3 = mathTransform.transform(directPosition3, n2 == n3 ? directPosition3 : null);
        directPosition4 = mathTransform.transform(directPosition4, n2 == n3 ? directPosition4 : null);
        for (n = 0; n < n3; ++n) {
            directPosition4.setOrdinate(n, directPosition4.getOrdinate(n) - directPosition3.getOrdinate(n));
        }
        return directPosition4;
    }

    public static Point2D deltaTransform(MathTransform2D mathTransform2D, Point2D point2D, Point2D point2D2, Point2D point2D3) throws TransformException {
        if (mathTransform2D instanceof AffineTransform) {
            return ((AffineTransform)((Object)mathTransform2D)).deltaTransform(point2D2, point2D3);
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX() * 0.5;
        double d4 = point2D2.getY() * 0.5;
        Point2D point2D4 = new Point2D.Double(d - d3, d2 - d4);
        Point2D point2D5 = new Point2D.Double(d + d3, d2 + d4);
        point2D4 = mathTransform2D.transform(point2D4, point2D4);
        point2D5 = mathTransform2D.transform(point2D5, point2D5);
        if (point2D3 == null) {
            point2D3 = point2D5;
        }
        point2D3.setLocation(point2D5.getX() - point2D4.getX(), point2D5.getY() - point2D4.getY());
        return point2D3;
    }
}

