/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.awt.geom.AffineTransform;
import javax.vecmath.SingularMatrixException;
import org.geotoolkit.referencing.operation.matrix.AffineMatrix3;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.Matrix1;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.matrix.Matrix3;
import org.geotoolkit.referencing.operation.matrix.Matrix4;
import org.geotoolkit.referencing.operation.matrix.MatrixFactory;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public final class MatrixUtilities {
    private MatrixUtilities() {
    }

    public static XMatrix toXMatrix(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        if (matrix instanceof XMatrix) {
            return (XMatrix)matrix;
        }
        return MatrixFactory.create(matrix);
    }

    public static XMatrix toOptimalMatrix(Matrix matrix) {
        int n = matrix.getNumRow();
        if (n == matrix.getNumCol()) {
            switch (n) {
                case 1: {
                    return matrix instanceof Matrix1 ? (Matrix1)matrix : new Matrix1(matrix);
                }
                case 2: {
                    return matrix instanceof Matrix2 ? (Matrix2)matrix : new Matrix2(matrix);
                }
                case 3: {
                    return matrix instanceof Matrix3 ? (Matrix3)matrix : new Matrix3(matrix);
                }
                case 4: {
                    return matrix instanceof Matrix4 ? (Matrix4)matrix : new Matrix4(matrix);
                }
            }
        }
        return MatrixUtilities.toXMatrix(matrix);
    }

    public static GeneralMatrix toGeneralMatrix(Matrix matrix) {
        if (matrix instanceof GeneralMatrix) {
            return (GeneralMatrix)matrix;
        }
        return new GeneralMatrix(matrix);
    }

    public static AffineTransform toAffineTransform(Matrix matrix) throws IllegalStateException {
        Matrix3 matrix3;
        if (matrix instanceof AffineTransform) {
            return (AffineTransform)((Object)matrix);
        }
        if (matrix instanceof Matrix3) {
            matrix3 = (Matrix3)matrix;
        } else {
            if (matrix instanceof GeneralMatrix) {
                return ((GeneralMatrix)matrix).toAffineTransform2D();
            }
            matrix3 = new Matrix3(matrix);
        }
        return matrix3.toAffineTransform();
    }

    private static AffineMatrix3 toAffineMatrix3(Matrix matrix) throws IllegalStateException {
        AffineTransform affineTransform = MatrixUtilities.toAffineTransform(matrix);
        return affineTransform instanceof AffineMatrix3 ? (AffineMatrix3)affineTransform : new AffineMatrix3(affineTransform);
    }

    private static boolean isAffineTransform(Matrix matrix) {
        return matrix.getNumRow() == 3 && matrix.getNumCol() == 3 && matrix.getElement(2, 0) == 0.0 && matrix.getElement(2, 1) == 0.0 && matrix.getElement(2, 2) == 1.0;
    }

    public static Matrix invert(Matrix matrix) throws NoninvertibleTransformException {
        Exception exception;
        Object object;
        if (MatrixUtilities.isAffineTransform(matrix)) {
            object = MatrixUtilities.toAffineMatrix3(matrix);
            try {
                ((AffineTransform)object).invert();
                return object;
            }
            catch (java.awt.geom.NoninvertibleTransformException noninvertibleTransformException) {
                exception = noninvertibleTransformException;
            }
        } else {
            object = MatrixUtilities.toOptimalMatrix(matrix);
            try {
                object.invert();
                return object;
            }
            catch (SingularMatrixException singularMatrixException) {
                exception = singularMatrixException;
            }
        }
        object = new NoninvertibleTransformException(Errors.format(113));
        ((Throwable)object).initCause(exception);
        throw object;
    }

    public static Matrix multiply(Matrix matrix, Matrix matrix2) {
        int n = matrix.getNumRow();
        int n2 = matrix2.getNumCol();
        if (n2 == matrix.getNumCol()) {
            if (MatrixUtilities.isAffineTransform(matrix) && MatrixUtilities.isAffineTransform(matrix2)) {
                AffineMatrix3 affineMatrix3 = MatrixUtilities.toAffineMatrix3(matrix);
                affineMatrix3.concatenate(MatrixUtilities.toAffineTransform(matrix2));
                return affineMatrix3;
            }
            XMatrix xMatrix = MatrixUtilities.toOptimalMatrix(matrix);
            xMatrix.multiply(matrix2);
            return xMatrix;
        }
        GeneralMatrix generalMatrix = new GeneralMatrix(n, n2);
        generalMatrix.mul(MatrixUtilities.toGeneralMatrix(matrix), MatrixUtilities.toGeneralMatrix(matrix2));
        return generalMatrix;
    }

    public static boolean epsilonEqual(Matrix matrix, Matrix matrix2, double d, boolean bl) {
        int n = matrix.getNumRow();
        if (n != matrix2.getNumRow()) {
            return false;
        }
        int n2 = matrix.getNumCol();
        if (n2 != matrix2.getNumCol()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2 = matrix.getElement(i, j);
                double d3 = matrix2.getElement(i, j);
                double d4 = d;
                if (bl) {
                    d4 *= Math.max(Math.abs(d2), Math.abs(d3));
                }
                if (Math.abs(d2 - d3) <= d4 || Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3)) continue;
                return false;
            }
        }
        return true;
    }
}

