/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.rmi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.geotoolkit.internal.rmi.LocalFuture;
import org.geotoolkit.internal.rmi.RemoteService;
import org.geotoolkit.internal.rmi.ShareableTask;
import org.geotoolkit.internal.rmi.TaskExecutor;
import org.geotoolkit.internal.rmi.TaskFuture;
import org.geotoolkit.util.logging.Logging;

final class LocalExecutor
implements TaskExecutor {
    private final ExecutorService executor;

    LocalExecutor(boolean bl) {
        this.executor = bl ? Executors.newCachedThreadPool() : null;
    }

    static String hostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            Logging.unexpectedException(RemoteService.logger(), LocalExecutor.class, "name", unknownHostException);
        }
        catch (SecurityException securityException) {
            Logging.recoverableException(RemoteService.logger(), LocalExecutor.class, "name", securityException);
        }
        return "localhost";
    }

    @Override
    public String name() {
        return LocalExecutor.hostname();
    }

    @Override
    public <Input, Output> TaskFuture<Output> submit(ShareableTask<Input, Output> shareableTask) {
        return new LocalFuture<Output>(this.executor != null ? this.executor.submit(shareableTask) : null, shareableTask);
    }

    @Override
    public void slave(TaskExecutor taskExecutor, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }
}

