/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.geotoolkit.internal.StringUtilities;
import org.geotoolkit.internal.sql.Dialect;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.XArrays;

public class ScriptRunner
implements FilenameFilter {
    public static final char END_OF_STATEMENT = ';';
    public static final char QUOTE = '\'';
    public static final char IDENTIFIER_QUOTE = '\"';
    protected final String identifierQuote;
    private String encoding;
    protected final List<String> suffixes = new ArrayList<String>();
    protected final Dialect dialect;
    protected final Map<String, String> replacements = new HashMap<String, String>();
    private final Statement statement;
    private File currentFile;
    private int currentLine;
    private String currentSQL;

    public ScriptRunner(Connection connection) throws SQLException {
        if (connection != null) {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.dialect = Dialect.guess(databaseMetaData);
            this.identifierQuote = databaseMetaData.getIdentifierQuoteString();
            this.statement = connection.createStatement();
        } else {
            this.dialect = Dialect.ANSI;
            this.identifierQuote = "\"";
            this.statement = null;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public boolean accept(File file, String string) {
        int n = string.lastIndexOf(46);
        return n > 0 && string.charAt(0) != '.' && string.regionMatches(true, n + 1, "sql", 0, 3);
    }

    public int run(File file) throws IOException, SQLException {
        if (file.isDirectory()) {
            return this.run(file, file.list(this));
        }
        return this.runFile(file);
    }

    final int run(File file, String[] stringArray) throws IOException, SQLException {
        if (stringArray.length == 0) {
            return 0;
        }
        String string = null;
        String string2 = null;
        for (String object2 : stringArray) {
            string = StringUtilities.commonPrefix(string, object2);
            string2 = StringUtilities.commonSuffix(string2, object2);
        }
        int n = string.length();
        int n2 = string2.length();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        final HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String[] stringArray2 = new String[stringArray.length];
        for (int string6 = 0; string6 < stringArray.length; ++string6) {
            String n4 = stringArray[string6];
            String i = n4.substring(n, n4.length() - n2);
            int n3 = this.suffixes.size();
            for (int j = 0; j < n3; ++j) {
                String string3 = this.suffixes.get(j);
                if (!i.endsWith(string3)) continue;
                i = i.substring(0, i.length() - string3.length());
                hashMap.put(n4, j);
                break;
            }
            stringArray2[string6] = i;
            linkedHashSet.add(i);
        }
        String string4 = this.selectVersion(linkedHashSet.toArray(new String[linkedHashSet.size()]));
        int n4 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string4.equals(stringArray2[i])) continue;
            stringArray[n4++] = stringArray[i];
        }
        stringArray = XArrays.resize(stringArray, n4);
        Arrays.sort(stringArray, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                Integer n;
                Integer n2 = (Integer)hashMap.get(string);
                if (n2 == (n = (Integer)hashMap.get(string2))) {
                    return 0;
                }
                if (n2 == null) {
                    return 1;
                }
                if (n == null) {
                    return -1;
                }
                return n2 - n;
            }
        });
        n4 = 0;
        for (String string3 : stringArray) {
            n4 += this.runFile(new File(file, string3));
        }
        return n4;
    }

    int runFile(File file) throws IOException, SQLException {
        String string = this.encoding;
        InputStreamReader inputStreamReader = string == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), string);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        this.currentFile = file;
        int n = this.run(lineNumberReader);
        lineNumberReader.close();
        this.currentFile = null;
        return n;
    }

    public int run(InputStream inputStream) throws IOException, SQLException {
        InputStreamReader inputStreamReader = this.encoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.encoding);
        return this.run(new LineNumberReader(inputStreamReader));
    }

    public int run(LineNumberReader lineNumberReader) throws IOException, SQLException {
        String string;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        block5: while ((string = lineNumberReader.readLine()) != null) {
            int n2 = stringBuilder.length();
            if (n2 == 0) {
                this.currentLine = lineNumberReader.getLineNumber();
            } else {
                ++n2;
                stringBuilder.append('\n');
            }
            stringBuilder.append(string);
            int n3 = stringBuilder.length();
            while (n2 < n3) {
                char c = stringBuilder.charAt(n2);
                switch (c) {
                    case '\"': {
                        if (bl) break;
                        bl2 = !bl2;
                        stringBuilder.replace(n2, n2 + 1, this.identifierQuote);
                        n2 += this.identifierQuote.length() - 1;
                        break;
                    }
                    case '\'': {
                        if (bl2) break;
                        if (!bl) {
                            bl = true;
                            break;
                        }
                        if (n2 + 1 == n3 || stringBuilder.charAt(n2 + 1) != '\'') {
                            bl = false;
                            break;
                        }
                        ++n2;
                        break;
                    }
                    case ';': {
                        if (bl || bl2) break;
                        int n4 = n2;
                        while (++n2 < n3) {
                            if (Character.isSpaceChar(stringBuilder.charAt(n2))) continue;
                            n4 = n3;
                            break;
                        }
                        stringBuilder.setLength(n4);
                        n += this.execute(stringBuilder);
                        stringBuilder.setLength(0);
                        continue block5;
                    }
                    default: {
                        if (bl || bl2 || !Character.isJavaIdentifierStart(c)) break;
                        int n4 = n2;
                        while (++n2 < n3 && Character.isJavaIdentifierPart(stringBuilder.charAt(n2))) {
                        }
                        String string2 = stringBuilder.substring(n4, n2);
                        String string3 = this.replacements.get(string2);
                        if (string3 != null) {
                            stringBuilder.replace(n4, n2, string3);
                            n2 = n4 + string3.length();
                            n3 = stringBuilder.length();
                        }
                        --n2;
                    }
                }
                ++n2;
            }
        }
        return n;
    }

    protected String selectVersion(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Version version = null;
        String string = stringArray[stringArray.length - 1];
        for (String string2 : stringArray) {
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c < '0' || c > '9') continue;
                stringBuilder.setLength(0);
                while (i < n) {
                    if (!Character.isLetterOrDigit(c = string2.charAt(i++))) {
                        c = '.';
                    }
                    stringBuilder.append(c);
                }
                Version version2 = new Version(stringBuilder.toString());
                if (version != null && version.compareTo(version2) > 0) continue;
                version = version2;
                string = string2;
            }
        }
        return string;
    }

    protected int execute(StringBuilder stringBuilder) throws SQLException, IOException {
        if (this.statement == null) {
            return 0;
        }
        this.currentSQL = stringBuilder.toString();
        int n = this.statement.executeUpdate(this.currentSQL);
        this.currentSQL = null;
        return n;
    }

    public void close() throws SQLException {
        if (this.statement != null) {
            switch (this.dialect) {
                case POSTGRESQL: {
                    this.statement.executeUpdate("VACUUM FULL");
                }
            }
            this.statement.close();
        }
    }

    public String getCurrentPosition() {
        String string = null;
        if (this.currentFile != null) {
            string = Vocabulary.format(98, this.currentFile, this.currentLine);
        }
        if (this.currentSQL != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                stringBuilder.append(string).append('\n');
            }
            string = stringBuilder.append("SQL: ").append(this.currentSQL).toString();
        }
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        if (this.currentFile != null) {
            stringBuilder.append(this.currentFile.getName()).append(" : ").append(this.currentLine);
        }
        stringBuilder.append(']');
        if (this.currentSQL != null) {
            stringBuilder.append('\n').append(this.currentSQL);
        }
        return stringBuilder.toString();
    }
}

