/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class DefaultFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
FilenameFilter {
    private final String description;
    private final Pattern pattern;

    public DefaultFileFilter(String string) {
        this(string, new File(string).getName());
    }

    public DefaultFileFilter(String string, String string2) {
        this.description = string2.trim();
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 8);
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                switch (c) {
                    case '?': {
                        stringBuilder.append('.');
                        continue block4;
                    }
                    case '*': {
                        stringBuilder.append(".*");
                        continue block4;
                    }
                    default: {
                        stringBuilder.append('\\');
                    }
                }
            }
            stringBuilder.append(c);
        }
        this.pattern = Pattern.compile(stringBuilder.toString());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean accept(File file) {
        return file != null && this.pattern.matcher(file.getName()).matches();
    }

    @Override
    public boolean accept(File file, String string) {
        return string != null && this.pattern.matcher(string).matches();
    }
}

