/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.geotoolkit.util.Utilities;

public class IndentedLineWriter
extends FilterWriter {
    private String margin = "";
    private boolean newLine = true;
    private boolean waitLF;

    public IndentedLineWriter(Writer writer) {
        super(writer);
    }

    public IndentedLineWriter(Writer writer, int n) {
        super(writer);
        this.setIndentation(n);
    }

    public int getIdentation() {
        return this.margin.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndentation(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.margin = Utilities.spaces(n);
        }
    }

    protected void beginNewLine() throws IOException {
        this.out.write(this.margin);
    }

    private void doWrite(int n) throws IOException {
        assert (Thread.holdsLock(this.lock));
        if (this.newLine && (n != 10 || !this.waitLF)) {
            this.beginNewLine();
        }
        this.out.write(n);
        this.newLine = n == 13 || n == 10;
        if (this.newLine) {
            this.waitLF = n == 13;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.doWrite(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        Object object = this.lock;
        synchronized (object) {
            block3: while (n < n3) {
                if (this.newLine) {
                    this.doWrite(cArray[n++]);
                    continue;
                }
                int n4 = n;
                do {
                    char c;
                    if ((c = cArray[n]) != '\r' && c != '\n') continue;
                    this.out.write(cArray, n4, n - n4);
                    this.doWrite(c);
                    ++n;
                    continue block3;
                } while (++n < n3);
                this.out.write(cArray, n4, n - n4);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        int n3 = n + n2;
        Object object = this.lock;
        synchronized (object) {
            block3: while (n < n3) {
                if (this.newLine) {
                    this.doWrite(string.charAt(n++));
                    continue;
                }
                int n4 = n;
                do {
                    char c;
                    if ((c = string.charAt(n)) != '\r' && c != '\n') continue;
                    this.out.write(string, n4, n - n4);
                    this.doWrite(c);
                    ++n;
                    continue block3;
                } while (++n < n3);
                this.out.write(string, n4, n - n4);
                break;
            }
        }
    }
}

