/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Locale;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.converter.ClassFilter;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.ConverterRegistry;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.ObjectConverter;

public class LineFormat
extends Format {
    private static final long serialVersionUID = 1257759127594136266L;
    private transient int count;
    private Object[] data;
    private final Format[] formats;
    private transient ParsePosition position = new ParsePosition(0);
    private int[] limits;
    private String line;
    private transient ObjectConverter<?, Number> toNumber;

    public LineFormat() {
        this(NumberFormat.getNumberInstance());
    }

    public LineFormat(Locale locale) {
        this(NumberFormat.getNumberInstance(locale));
    }

    public LineFormat(Format format) {
        if (format == null) {
            throw new NullArgumentException(Errors.format(154, 0, 1));
        }
        this.data = new Object[16];
        this.limits = new int[this.data.length + 1];
        this.formats = new Format[]{format};
    }

    public LineFormat(Format[] formatArray) {
        if (formatArray.length == 0) {
            throw new IllegalArgumentException(Errors.format(49));
        }
        formatArray = (Format[])formatArray.clone();
        this.formats = formatArray;
        this.data = new Object[formatArray.length];
        this.limits = new int[formatArray.length + 1];
        for (int i = 0; i < formatArray.length; ++i) {
            if (formatArray[i] != null) continue;
            throw new NullArgumentException(Errors.format(154, i + 1, formatArray.length));
        }
    }

    public Class<?> getElementType(ClassFilter classFilter) {
        Class<?> clazz = null;
        Class[] classArray = new Class[]{String.class};
        for (Format format : this.formats) {
            Class<?> clazz2;
            try {
                clazz2 = format.getClass().getMethod("parse", classArray).getReturnType();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return Object.class;
            }
            if (clazz == null) {
                clazz = clazz2;
                continue;
            }
            if (clazz2 == null || classFilter != null && !classFilter.accepts(clazz2)) continue;
            clazz = Classes.findCommonClass(clazz, clazz2);
        }
        return clazz;
    }

    public void clear() {
        this.toNumber = null;
        this.line = null;
        this.count = 0;
        Arrays.fill(this.data, null);
    }

    public int setLine(String string) throws ParseException {
        return this.setLine(string, 0, string.length());
    }

    public int setLine(String string, int n, int n2) throws ParseException {
        this.line = string;
        Arrays.fill(this.data, null);
        this.count = 0;
        while (n < n2) {
            if (Character.isWhitespace(string.charAt(n))) {
                ++n;
                continue;
            }
            this.position.setIndex(n);
            Object object = this.formats[Math.min(this.count, this.formats.length - 1)].parseObject(string, this.position);
            int n3 = this.position.getIndex();
            if (object == null || n3 <= n) {
                int n4;
                int n5;
                for (n5 = n4 = this.position.getErrorIndex(); n5 < n2 && !Character.isWhitespace(string.charAt(n5)); ++n5) {
                }
                throw new ParseException(Errors.format(163, string.substring(n, n5).trim(), string.substring(n4, Math.min(n4 + 1, n5))), n4);
            }
            if (this.count >= this.data.length) {
                this.data = Arrays.copyOf(this.data, this.count + Math.min(this.count, 256));
                this.limits = Arrays.copyOf(this.limits, this.data.length + 1);
            }
            this.limits[this.count] = n;
            this.data[this.count++] = object;
            n = n3;
        }
        this.limits[this.count] = n;
        return this.count;
    }

    public int getValueCount() {
        return this.count;
    }

    public void setValues(Object object) throws IllegalArgumentException {
        int n = Array.getLength(object);
        this.data = XArrays.resize(this.data, n);
        this.limits = XArrays.resize(this.limits, n + 1);
        for (int i = 0; i < n; ++i) {
            this.data[i] = Array.get(object, i);
        }
        this.count = n;
    }

    public void setValue(int n, Object object) throws ArrayIndexOutOfBoundsException {
        if (n > this.count) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, "value"));
        }
        if (n == this.count) {
            if (n == this.data.length) {
                this.data = Arrays.copyOf(this.data, n + Math.min(n, 256));
                this.limits = Arrays.copyOf(this.limits, this.data.length + 1);
            }
            ++this.count;
        }
        this.data[n] = object;
    }

    public Object getValue(int n) throws ArrayIndexOutOfBoundsException {
        if (n < this.count) {
            return this.data[n];
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    private Number getNumber(int n) throws ParseException {
        Object object = this.data[n];
        if (object instanceof Number) {
            return (Number)object;
        }
        try {
            Serializable serializable;
            if (this.toNumber == null) {
                serializable = this.getElementType(ClassFilter.NUMBER.negate());
                this.toNumber = ConverterRegistry.system().converter(serializable, Number.class);
            }
            serializable = this.toNumber.convert(object);
            return serializable;
        }
        catch (NonconvertibleObjectException nonconvertibleObjectException) {
            ParseException parseException = new ParseException(Errors.format(202, this.data[n]), this.limits[n]);
            parseException.initCause(nonconvertibleObjectException);
            throw parseException;
        }
    }

    public double[] getValues(double[] dArray) throws ParseException {
        if (dArray != null) {
            this.checkLength(dArray.length);
        } else {
            dArray = new double[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            dArray[i] = this.getNumber(i).doubleValue();
        }
        return dArray;
    }

    public float[] getValues(float[] fArray) throws ParseException {
        if (fArray != null) {
            this.checkLength(fArray.length);
        } else {
            fArray = new float[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            fArray[i] = this.getNumber(i).floatValue();
        }
        return fArray;
    }

    public long[] getValues(long[] lArray) throws ParseException {
        if (lArray != null) {
            this.checkLength(lArray.length);
        } else {
            lArray = new long[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number number = this.getNumber(i);
            lArray[i] = number.longValue();
            if ((double)lArray[i] == number.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return lArray;
    }

    public int[] getValues(int[] nArray) throws ParseException {
        if (nArray != null) {
            this.checkLength(nArray.length);
        } else {
            nArray = new int[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number number = this.getNumber(i);
            nArray[i] = number.intValue();
            if ((double)nArray[i] == number.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return nArray;
    }

    public short[] getValues(short[] sArray) throws ParseException {
        if (sArray != null) {
            this.checkLength(sArray.length);
        } else {
            sArray = new short[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number number = this.getNumber(i);
            sArray[i] = number.shortValue();
            if ((double)sArray[i] == number.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return sArray;
    }

    public byte[] getValues(byte[] byArray) throws ParseException {
        if (byArray != null) {
            this.checkLength(byArray.length);
        } else {
            byArray = new byte[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number number = this.getNumber(i);
            byArray[i] = number.byteValue();
            if ((double)byArray[i] == number.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return byArray;
    }

    private void checkLength(int n) throws ParseException {
        if (this.count != n) {
            int n2 = this.limits[Math.min(this.count, n)];
            int n3 = this.limits[Math.min(this.count, n + 1)];
            throw new ParseException(Errors.format(this.count < n ? 94 : 93, this.count, n, this.line.substring(n2, n3).trim()), n2);
        }
    }

    private ParseException notAnInteger(int n) {
        return new ParseException(Errors.format(128, this.line.substring(this.limits[n], this.limits[n + 1])), this.limits[n]);
    }

    public String toString() {
        return this.toString(new StringBuffer()).toString();
    }

    private StringBuffer toString(StringBuffer stringBuffer) {
        FieldPosition fieldPosition = new FieldPosition(0);
        for (int i = 0; i < this.count; ++i) {
            if (i != 0) {
                stringBuffer.append('\t');
            }
            stringBuffer = this.formats[Math.min(this.formats.length - 1, i)].format(this.data[i], stringBuffer, fieldPosition);
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.setValues(object);
        return this.toString(stringBuffer);
    }

    private static int getLineEnd(String string, int n, boolean bl) {
        char c;
        int n2 = string.length();
        while (n < n2 && ((c = string.charAt(n)) == '\r' || c == '\n') != bl) {
            ++n;
        }
        return n;
    }

    public Object[] parseObject(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        int n2 = LineFormat.getLineEnd(string, n, true);
        try {
            this.setLine(string.substring(n, n2));
            parsePosition.setIndex(LineFormat.getLineEnd(string, n2, false));
            return Arrays.copyOf(this.data, this.count);
        }
        catch (ParseException parseException) {
            parsePosition.setErrorIndex(parseException.getErrorOffset());
            return null;
        }
    }

    public Object[] parseObject(String string) throws ParseException {
        this.setLine(string.substring(0, LineFormat.getLineEnd(string, 0, true)));
        return Arrays.copyOf(this.data, this.count);
    }

    @Override
    public LineFormat clone() {
        LineFormat lineFormat = (LineFormat)super.clone();
        lineFormat.data = (Object[])this.data.clone();
        lineFormat.limits = (int[])this.limits.clone();
        return lineFormat;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.data = XArrays.resize(this.data, this.count);
        this.limits = XArrays.resize(this.limits, this.count + 1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.count = this.data.length;
        this.position = new ParsePosition(0);
    }
}

