/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import org.geotoolkit.internal.StringUtilities;
import org.geotoolkit.io.LineReader;

public final class LineReaders {
    private LineReaders() {
    }

    public static LineReader wrap(String string) {
        return LineReaders.wrap(Arrays.asList(StringUtilities.splitLines(string)));
    }

    public static LineReader wrap(Iterable<?> iterable) {
        final Iterator<?> iterator = iterable.iterator();
        return new LineReader(){

            @Override
            public String readLine() throws IOException {
                try {
                    return iterator.hasNext() ? iterator.next().toString() : null;
                }
                catch (RuntimeException runtimeException) {
                    Throwable throwable = runtimeException.getCause();
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    throw runtimeException;
                }
            }
        };
    }

    public static LineReader wrap(final DataInput dataInput) {
        if (dataInput instanceof LineReader) {
            return (LineReader)((Object)dataInput);
        }
        return new LineReader(){

            @Override
            public String readLine() throws IOException {
                return dataInput.readLine();
            }
        };
    }

    public static LineReader wrap(Reader reader) {
        if (reader instanceof LineReader) {
            return (LineReader)((Object)reader);
        }
        if (reader instanceof BufferedReader) {
            final BufferedReader bufferedReader = (BufferedReader)reader;
            return new LineReader(){

                @Override
                public String readLine() throws IOException {
                    return bufferedReader.readLine();
                }
            };
        }
        return new Buffered(reader);
    }

    private static final class Buffered
    extends BufferedReader
    implements LineReader {
        Buffered(Reader reader) {
            super(reader);
        }
    }
}

