/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.geotoolkit.util.NullArgumentException;

public class LineWriter
extends FilterWriter {
    private String lineSeparator;
    private boolean skipCR;
    private char[] buffer = new char[64];
    private int count = 0;

    public LineWriter(Writer writer) {
        this(writer, System.getProperty("line.separator", "\n"));
    }

    public LineWriter(Writer writer, String string) {
        super(writer);
        this.lineSeparator = string;
        if (writer == null || string == null) {
            throw new NullArgumentException();
        }
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineSeparator(String string) {
        if (string == null) {
            throw new NullArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.lineSeparator = string;
        }
    }

    private void writeEOL() throws IOException {
        assert (this.count == 0) : this.count;
        this.out.write(this.lineSeparator);
    }

    private boolean bufferBlank() throws IOException {
        int n = this.count;
        while (--n >= 0) {
            if (this.isWhitespace(this.buffer[n])) continue;
            return false;
        }
        return true;
    }

    private void flushBuffer() throws IOException {
        assert (this.bufferBlank());
        if (this.count != 0) {
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
        }
    }

    private void writeLine(char[] cArray, int n, int n2) throws IOException {
        while (n2 != n) {
            char c = cArray[n2 - 1];
            assert (c != '\r' && c != '\n');
            if (this.isWhitespace(c)) {
                --n2;
                continue;
            }
            this.flushBuffer();
            this.out.write(cArray, n, n2 - n);
            return;
        }
        assert (this.bufferBlank());
        this.count = 0;
    }

    private void writeLine(String string, int n, int n2) throws IOException {
        while (n2 != n) {
            char c = string.charAt(n2 - 1);
            assert (c != '\r' && c != '\n');
            if (this.isWhitespace(c)) {
                --n2;
                continue;
            }
            this.flushBuffer();
            this.out.write(string, n, n2 - n);
            return;
        }
        assert (this.bufferBlank());
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            switch (n) {
                case 13: {
                    assert (this.bufferBlank());
                    this.count = 0;
                    this.writeEOL();
                    this.skipCR = true;
                    break;
                }
                case 10: {
                    if (!this.skipCR) {
                        assert (this.bufferBlank());
                        this.count = 0;
                        this.writeEOL();
                    }
                    this.skipCR = false;
                    break;
                }
                default: {
                    if (n >= 0 && n <= 65535 && this.isWhitespace((char)n)) {
                        if (this.count >= this.buffer.length) {
                            this.buffer = Arrays.copyOf(this.buffer, this.count + Math.min(8192, this.count));
                        }
                        this.buffer[this.count++] = (char)n;
                    } else {
                        this.flushBuffer();
                        this.out.write(n);
                    }
                    this.skipCR = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.skipCR && cArray[n] == '\n') {
                ++n;
                --n2;
            }
            int n3 = n;
            while (n2 != 0) {
                switch (cArray[n3++]) {
                    case '\r': {
                        this.writeLine(cArray, n, n3 - 1);
                        this.writeEOL();
                        if (n2 > 1 && cArray[n3] == '\n') {
                            --n2;
                        }
                        n = ++n3;
                        break;
                    }
                    case '\n': {
                        this.writeLine(cArray, n, n3 - 1);
                        this.writeEOL();
                        n = n3;
                    }
                }
                --n2;
            }
            this.skipCR = cArray[n3 - 1] == '\r';
            int n4 = n3;
            while (--n4 >= n) {
                if (this.isWhitespace(cArray[n4])) continue;
                int n5 = n;
                n = n4 + 1;
                this.writeLine(cArray, n5, n);
                break;
            }
            if ((n4 = this.count + (n2 = n3 - n)) > this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, n4);
            }
            System.arraycopy(cArray, n, this.buffer, this.count, n2);
            this.count = n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.skipCR && string.charAt(n) == '\n') {
                ++n;
                --n2;
            }
            int n3 = n;
            while (n2 != 0) {
                switch (string.charAt(n3++)) {
                    case '\r': {
                        this.writeLine(string, n, n3 - 1);
                        this.writeEOL();
                        if (n2 > 1 && string.charAt(n3) == '\n') {
                            --n2;
                        }
                        n = ++n3;
                        break;
                    }
                    case '\n': {
                        this.writeLine(string, n, n3 - 1);
                        this.writeEOL();
                        n = n3;
                    }
                }
                --n2;
            }
            this.skipCR = string.charAt(n3 - 1) == '\r';
            int n4 = n3;
            while (--n4 >= n) {
                if (this.isWhitespace(string.charAt(n4))) continue;
                int n5 = n;
                n = n4 + 1;
                this.writeLine(string, n5, n);
                break;
            }
            if ((n4 = this.count + (n2 = n3 - n)) > this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, n4);
            }
            string.getChars(n, n + n2, this.buffer, this.count);
            this.count = n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            super.flush();
        }
    }

    protected boolean isWhitespace(char c) throws IOException {
        return Character.isSpaceChar(c);
    }
}

