/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.io.PrintWriter;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotoolkit.io.wkt.Parser;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.logging.LoggedFormat;

final class Element {
    private final int offset;
    public final String keyword;
    private final List<Object> list;

    Element(Element element) {
        this.offset = 0;
        this.keyword = null;
        this.list = new LinkedList<Object>();
        this.list.add(element);
    }

    Element(Parser parser, String string, ParsePosition parsePosition) throws ParseException {
        int n;
        int n2;
        int n3 = string.length();
        for (n2 = parsePosition.getIndex(); n2 < n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        this.offset = n2;
        for (n = n2; n < n3 && Character.isUnicodeIdentifierPart(string.charAt(n)); ++n) {
        }
        if (n <= n2) {
            parsePosition.setErrorIndex(n2);
            throw this.unparsableString(string, parsePosition);
        }
        Symbols symbols = parser.getSymbols();
        this.keyword = string.substring(n2, n).toUpperCase(symbols.locale);
        parsePosition.setIndex(n);
        int n4 = -1;
        do {
            if (++n4 < symbols.openingBrackets.length) continue;
            this.list = null;
            return;
        } while (!Element.parseOptionalSeparator(string, parsePosition, symbols.openingBrackets[n4]));
        this.list = new LinkedList<Object>();
        do {
            if (parsePosition.getIndex() >= n3) {
                throw this.missingCharacter(symbols.close, n3);
            }
            if (Element.parseOptionalSeparator(string, parsePosition, symbols.quote)) {
                n2 = parsePosition.getIndex();
                n = string.indexOf(symbols.quote, n2);
                if (n < n2) {
                    parsePosition.setErrorIndex(++n2);
                    throw this.missingCharacter(symbols.quote, n2);
                }
                this.list.add(string.substring(n2, n).trim());
                parsePosition.setIndex(n + 1);
                continue;
            }
            n2 = parsePosition.getIndex();
            if (!Character.isUnicodeIdentifierStart(string.charAt(n2))) {
                Number number = parser.parseNumber(string, parsePosition);
                if (number == null) {
                    throw this.unparsableString(string, parsePosition);
                }
                this.list.add(number);
                continue;
            }
            if (string.regionMatches(true, n2, "TRUE", 0, 4)) {
                parsePosition.setIndex(n2 + 4);
                this.list.add(Boolean.TRUE);
                continue;
            }
            if (string.regionMatches(true, n2, "FALSE", 0, 5)) {
                parsePosition.setIndex(n2 + 5);
                this.list.add(Boolean.FALSE);
                continue;
            }
            this.list.add(new Element(parser, string, parsePosition));
        } while (Element.parseOptionalSeparator(string, parsePosition, symbols.separator));
        this.parseSeparator(string, parsePosition, symbols.closingBrackets[n4]);
    }

    private static boolean parseOptionalSeparator(String string, ParsePosition parsePosition, char c) {
        int n;
        int n2 = string.length();
        for (n = parsePosition.getIndex(); n < n2; ++n) {
            char c2 = string.charAt(n);
            if (Character.isWhitespace(c2)) {
                continue;
            }
            if (c2 != c) break;
            parsePosition.setIndex(++n);
            return true;
        }
        parsePosition.setIndex(n);
        return false;
    }

    private void parseSeparator(String string, ParsePosition parsePosition, char c) throws ParseException {
        if (!Element.parseOptionalSeparator(string, parsePosition, c)) {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            throw this.unparsableString(string, parsePosition);
        }
    }

    public ParseException parseFailed(Exception exception, String string) {
        if (string == null) {
            string = exception.getLocalizedMessage();
        }
        ParseException parseException = new ParseException(this.complete(string), this.offset);
        parseException = Element.trim("parseFailed", parseException);
        parseException.initCause(exception);
        return parseException;
    }

    private ParseException unparsableString(String string, ParsePosition parsePosition) {
        int n = parsePosition.getErrorIndex();
        String string2 = LoggedFormat.formatUnparsable(string, parsePosition.getIndex(), n, null);
        string2 = this.complete(string2);
        return Element.trim("unparsableString", new ParseException(string2, n));
    }

    private ParseException missingCharacter(char c, int n) {
        return Element.trim("missingCharacter", new ParseException(this.complete(Errors.format(104, Character.valueOf(c))), n));
    }

    private ParseException missingParameter(String string) {
        int n = this.offset;
        if (this.keyword != null) {
            n += this.keyword.length();
        }
        return Element.trim("missingParameter", new ParseException(this.complete(Errors.format(106, string)), n));
    }

    private String complete(String string) {
        if (this.keyword != null) {
            string = Errors.format(91, this.keyword) + ' ' + string;
        }
        return string;
    }

    private static ParseException trim(String string, ParseException parseException) {
        StackTraceElement[] stackTraceElementArray = parseException.getStackTrace();
        if (stackTraceElementArray != null && stackTraceElementArray.length != 0 && string.equals(stackTraceElementArray[0].getMethodName())) {
            stackTraceElementArray = XArrays.remove(stackTraceElementArray, 0, 1);
            parseException.setStackTrace(stackTraceElementArray);
        }
        return parseException;
    }

    public boolean isRoot() {
        return this.offset == 0;
    }

    public double pullDouble(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            return ((Number)object).doubleValue();
        }
        throw this.missingParameter(string);
    }

    public int pullInteger(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            Number number = (Number)object;
            if (number instanceof Float || number instanceof Double) {
                throw new ParseException(this.complete(Errors.format(63, string, number)), this.offset);
            }
            return number.intValue();
        }
        throw this.missingParameter(string);
    }

    public boolean pullBoolean(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Boolean)) continue;
            iterator.remove();
            return (Boolean)object;
        }
        throw this.missingParameter(string);
    }

    public String pullString(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.remove();
            return (String)object;
        }
        throw this.missingParameter(string);
    }

    public Object pullObject(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) continue;
            iterator.remove();
            return object;
        }
        throw this.missingParameter(string);
    }

    public Element pullElement(String string) throws ParseException {
        Element element = this.pullOptionalElement(string);
        if (element != null) {
            return element;
        }
        throw this.missingParameter(string);
    }

    public Element pullOptionalElement(String string) {
        string = string.toUpperCase();
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list == null || !element.keyword.equals(string)) continue;
            iterator.remove();
            return element;
        }
        return null;
    }

    public Element pullVoidElement(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list != null) continue;
            iterator.remove();
            return element;
        }
        throw this.missingParameter(string);
    }

    public Object peek() {
        return this.list.isEmpty() ? null : this.list.get(0);
    }

    public void close() throws ParseException {
        if (this.list != null && !this.list.isEmpty()) {
            throw new ParseException(this.complete(Errors.format(186, this.list.get(0))), this.offset + this.keyword.length());
        }
    }

    public String toString() {
        return this.keyword;
    }

    public void print(PrintWriter printWriter, int n) {
        printWriter.print(Utilities.spaces(4 * n));
        printWriter.println(this.keyword);
        if (this.list == null) {
            return;
        }
        int n2 = this.list.size();
        for (int i = 0; i < n2; ++i) {
            Object object = this.list.get(i);
            if (object instanceof Element) {
                ((Element)object).print(printWriter, n + 1);
                continue;
            }
            printWriter.print(Utilities.spaces(4 * (n + 1)));
            printWriter.println(object);
        }
    }
}

