/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.text.ParseException;
import java.text.ParsePosition;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.io.wkt.Element;
import org.geotoolkit.io.wkt.Parser;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;

public class MathTransformParser
extends Parser {
    final MathTransformFactory mtFactory;
    private transient String classification;
    private transient OperationMethod lastMethod;

    public MathTransformParser() {
        this(Symbols.DEFAULT, FactoryFinder.getMathTransformFactory(null));
    }

    public MathTransformParser(Symbols symbols, MathTransformFactory mathTransformFactory) {
        super(symbols);
        this.mtFactory = mathTransformFactory;
        MathTransformParser.ensureNonNull("mtFactory", mathTransformFactory);
    }

    public final MathTransform parseMathTransform(String string) throws ParseException {
        Element element = this.getTree(string, new ParsePosition(0));
        MathTransform mathTransform = this.parseMathTransform(element, true);
        element.close();
        return mathTransform;
    }

    @Override
    Object parse(Element element) throws ParseException {
        return this.parseMathTransform(element, true);
    }

    final MathTransform parseMathTransform(Element element, boolean bl) throws ParseException {
        this.lastMethod = null;
        this.classification = null;
        Object object = element.peek();
        if (object instanceof Element) {
            String string = this.keyword((Element)object);
            switch (string.hashCode()) {
                case 1954077369: {
                    if (!"PARAM_MT".equals(string)) break;
                    return this.parseParamMT(element);
                }
                case 1889286834: {
                    if (!"CONCAT_MT".equals(string)) break;
                    return this.parseConcatMT(element);
                }
                case -1910641354: {
                    if (!"INVERSE_MT".equals(string)) break;
                    return this.parseInverseMT(element);
                }
                case -219294638: {
                    if (!"PASSTHROUGH_MT".equals(string)) break;
                    return this.parsePassThroughMT(element);
                }
            }
        }
        if (bl) {
            throw element.parseFailed(null, Errors.format(198, object));
        }
        return null;
    }

    final MathTransform parseParamMT(Element element) throws ParseException {
        Object object;
        Element element2;
        ParameterValueGroup parameterValueGroup;
        Element element3 = element.pullElement("PARAM_MT");
        this.classification = element3.pullString("classification");
        try {
            parameterValueGroup = this.mtFactory.getDefaultParameters(this.classification);
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            throw element3.parseFailed(noSuchIdentifierException, null);
        }
        while ((element2 = element3.pullOptionalElement("PARAMETER")) != null) {
            object = element2.pullString("name");
            ParameterValue<?> parameterValue = parameterValueGroup.parameter((String)object);
            Class<?> clazz = parameterValue.getDescriptor().getValueClass();
            if (Integer.class.equals(clazz)) {
                parameterValue.setValue(element2.pullInteger("value"));
            } else if (Double.class.equals(clazz)) {
                parameterValue.setValue(element2.pullDouble("value"));
            } else if (Boolean.class.equals(clazz)) {
                parameterValue.setValue(element2.pullBoolean("value"));
            } else {
                parameterValue.setValue(element2.pullString("value"));
            }
            element2.close();
        }
        element3.close();
        try {
            object = this.mtFactory.createParameterizedTransform(parameterValueGroup);
        }
        catch (FactoryException factoryException) {
            throw element3.parseFailed(factoryException, null);
        }
        this.lastMethod = this.mtFactory.getLastMethodUsed();
        return object;
    }

    final MathTransform parseInverseMT(Element element) throws ParseException {
        Element element2 = element.pullElement("INVERSE_MT");
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw element2.parseFailed(noninvertibleTransformException, null);
        }
        element2.close();
        return mathTransform;
    }

    final MathTransform parsePassThroughMT(Element element) throws ParseException {
        Element element2 = element.pullElement("PASSTHROUGH_MT");
        int n = element.pullInteger("firstAffectedOrdinate");
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        element2.close();
        try {
            return this.mtFactory.createPassThroughTransform(n, mathTransform, 0);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    final MathTransform parseConcatMT(Element element) throws ParseException {
        MathTransform mathTransform;
        Element element2 = element.pullElement("CONCAT_MT");
        MathTransform mathTransform2 = this.parseMathTransform(element2, true);
        while ((mathTransform = this.parseMathTransform(element2, false)) != null) {
            try {
                mathTransform2 = this.mtFactory.createConcatenatedTransform(mathTransform2, mathTransform);
            }
            catch (FactoryException factoryException) {
                throw element2.parseFailed(factoryException, null);
            }
        }
        element2.close();
        return mathTransform2;
    }

    final OperationMethod getOperationMethod() {
        if (this.lastMethod == null && this.classification != null) {
            for (OperationMethod operationMethod : this.mtFactory.getAvailableMethods(SingleOperation.class)) {
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)operationMethod, this.classification)) continue;
                this.lastMethod = operationMethod;
                break;
            }
        }
        return this.lastMethod;
    }
}

