/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.geotoolkit.io.wkt.Element;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;

public abstract class Parser {
    static final boolean SCIENTIFIC_NOTATION = true;
    private Symbols symbols;
    private NumberFormat numberFormat;

    Parser(Symbols symbols) {
        this.setSymbols(symbols);
    }

    static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, string));
        }
    }

    final void setSymbols(Symbols symbols) {
        DecimalFormat decimalFormat;
        String string;
        Parser.ensureNonNull("symbols", symbols);
        this.symbols = symbols;
        this.numberFormat = (NumberFormat)symbols.numberFormat.clone();
        if (this.numberFormat instanceof DecimalFormat && (string = (decimalFormat = (DecimalFormat)this.numberFormat).toPattern()).indexOf("E0") < 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            int n = string.indexOf(59);
            if (n >= 0) {
                stringBuilder.insert(n, "E0");
            }
            stringBuilder.append("E0");
            decimalFormat.applyPattern(stringBuilder.toString());
        }
    }

    final Symbols getSymbols() {
        return this.symbols;
    }

    public final Object parseObject(String string) throws ParseException {
        Element element = this.getTree(string, new ParsePosition(0));
        Object object = this.parse(element);
        element.close();
        return object;
    }

    public final Object parseObject(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        try {
            return this.parse(this.getTree(string, parsePosition));
        }
        catch (ParseException parseException) {
            parsePosition.setIndex(n);
            if (parsePosition.getErrorIndex() < n) {
                parsePosition.setErrorIndex(parseException.getErrorOffset());
            }
            return null;
        }
    }

    final Number parseNumber(String string, ParsePosition parsePosition) {
        int n;
        int n2 = parsePosition.getIndex();
        Number number = this.numberFormat.parse(string, parsePosition);
        if (number != null && (n = parsePosition.getIndex()) < string.length() && string.charAt(n) == 'e') {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.setCharAt(n, 'E');
            string = stringBuilder.toString();
            parsePosition.setIndex(n2);
            number = this.numberFormat.parse(string, parsePosition);
        }
        return number;
    }

    abstract Object parse(Element var1) throws ParseException;

    final Element getTree(String string, ParsePosition parsePosition) throws ParseException {
        return new Element(new Element(this, string, parsePosition));
    }

    final String keyword(Element element) {
        return element.keyword.trim().toUpperCase(this.symbols.locale);
    }

    final Formatter formatter() {
        return new Formatter(this.symbols, this.numberFormat);
    }
}

