/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.io.wkt.Colors;
import org.geotoolkit.io.wkt.Definitions;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.io.wkt.MathTransformParser;
import org.geotoolkit.io.wkt.Parser;
import org.geotoolkit.io.wkt.ReferencingParser;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.referencing.datum.BursaWolfParameters;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.MathTransform;

public class WKTFormat
extends Format {
    private static final long serialVersionUID = -2909110214650709560L;
    private static final Map<String, Class<?>> TYPES;
    private Symbols symbols = Symbols.DEFAULT;
    private Colors colors = null;
    private Citation authority = FormattableObject.OGC;
    private int indentation = FormattableObject.getDefaultIndentation();
    private Definitions definitions;
    private transient Parser parser;
    private transient Formatter formatter;

    public WKTFormat() {
    }

    public WKTFormat(Hints hints) {
        if (hints != null && !hints.isEmpty()) {
            this.parser = new ReferencingParser(this.symbols, hints);
        }
    }

    public Symbols getSymbols() {
        return this.symbols;
    }

    public void setSymbols(Symbols symbols) {
        if (symbols == null) {
            throw new NullArgumentException(Errors.format(152, "symbols"));
        }
        if (!symbols.equals(this.symbols)) {
            this.symbols = symbols;
            this.formatter = null;
            if (this.parser != null) {
                this.parser.setSymbols(symbols);
            }
            if (this.definitions != null) {
                this.definitions.quote = (char)symbols.quote;
            }
        }
    }

    public Colors getColors() {
        return this.colors;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
        if (this.formatter != null) {
            this.formatter.colors = colors;
        }
    }

    public Citation getAuthority() {
        return this.authority;
    }

    public void setAuthority(Citation citation) {
        if (citation == null) {
            throw new NullArgumentException(Errors.format(152, "authority"));
        }
        this.authority = citation;
        if (this.formatter != null) {
            this.formatter.authority = citation;
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int n) {
        this.indentation = n;
        if (this.formatter != null) {
            this.formatter.indentation = n;
        }
    }

    public Map<String, String> definitions() {
        if (this.definitions == null) {
            this.definitions = new Definitions(this);
            this.definitions.quote = (char)this.symbols.quote;
        }
        return this.definitions;
    }

    public void printDefinitions(Writer writer) throws IOException {
        if (this.definitions != null && !this.definitions.isEmpty()) {
            this.definitions.print(writer, this.colors != null);
        }
    }

    public <T> T parse(String string, int n, Class<T> clazz) throws ParseException {
        Object object;
        Object object2;
        if (Definitions.isIdentifier(string = string.substring(n))) {
            if (this.definitions == null || (object2 = this.definitions.getParsed(string)) == null) {
                throw new ParseException(Errors.format(146, clazz, string), 0);
            }
        } else {
            if (this.definitions != null) {
                string = this.definitions.substitute(string);
            }
            object = this.getParser();
            try {
                object2 = MathTransform.class.isAssignableFrom(clazz) && object instanceof MathTransformParser ? ((MathTransformParser)object).parseMathTransform(string) : (CoordinateReferenceSystem.class.isAssignableFrom(clazz) && object instanceof ReferencingParser ? ((ReferencingParser)object).parseCoordinateReferenceSystem(string) : ((Parser)object).parseObject(string));
            }
            catch (ParseException parseException) {
                ParseException parseException2;
                if (this.definitions != null) {
                    parseException2 = this.definitions.adjustErrorOffset(parseException, n);
                }
                throw parseException2;
            }
        }
        if (clazz.isAssignableFrom((Class<?>)(object = object2.getClass()))) {
            return clazz.cast(object2);
        }
        throw new ParseException(Errors.format(66, object, clazz), 0);
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        return this.parse(string, 0, Object.class);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        try {
            return this.parseObject(string.substring(n));
        }
        catch (ParseException parseException) {
            parsePosition.setIndex(n);
            parsePosition.setErrorIndex(parseException.getErrorOffset() + n);
            return null;
        }
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.parser = new ReferencingParser(this.symbols, (Hints)null);
        }
        return this.parser;
    }

    private Formatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = new Formatter(this.symbols, (NumberFormat)this.symbols.numberFormat.clone());
            this.formatter.colors = this.colors;
            this.formatter.authority = this.authority;
            this.formatter.indentation = this.indentation;
        }
        return this.formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Formatter formatter = this.getFormatter();
        try {
            formatter.clear();
            formatter.buffer = stringBuffer;
            formatter.bufferBase = stringBuffer.length();
            if (object instanceof MathTransform) {
                formatter.append((MathTransform)object);
            } else if (object instanceof GeneralParameterValue) {
                formatter.append((GeneralParameterValue)object);
            } else {
                formatter.append((IdentifiedObject)object);
            }
            StringBuffer stringBuffer2 = stringBuffer;
            return stringBuffer2;
        }
        finally {
            formatter.buffer = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reformat(Reader reader, Writer writer, PrintWriter printWriter) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator", "\n");
        Symbols symbols = this.getSymbols();
        char[] cArray = symbols.openingBrackets;
        char[] cArray2 = symbols.closingBrackets;
        int[] nArray = new int[Math.max(cArray.length, cArray2.length)];
        int n;
        while ((n = reader.read()) >= 0) {
            Object object;
            char c = (char)n;
            if (Character.isWhitespace(c)) continue;
            stringBuilder.setLength(0);
            block4: while (true) {
                int n2;
                if ((n = reader.read()) < 0) {
                    throw new EOFException(Errors.format(184));
                }
                c = (char)n;
                stringBuilder.append(c);
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    if (c != cArray[n2]) continue;
                    int n3 = n2;
                    nArray[n3] = nArray[n3] + 1;
                    continue block4;
                }
                n2 = 0;
                while (true) {
                    if (n2 >= cArray2.length) continue block4;
                    if (c == cArray2[n2]) {
                        int n4 = n2;
                        nArray[n4] = nArray[n4] - 1;
                        if (nArray[n4] < 0) {
                            throw new ContentFormatException(Errors.format(118, Character.valueOf(cArray2[n2]), Character.valueOf(cArray[n2])));
                        }
                        break;
                    }
                    ++n2;
                }
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] == 0) continue;
                    continue block4;
                }
                break;
            }
            String string2 = stringBuilder.toString();
            try {
                object = this.parseObject(string2);
            }
            catch (ParseException parseException) {
                printWriter.println(parseException.getLocalizedMessage());
                WKTFormat.reportError(printWriter, string2, parseException.getErrorOffset());
                continue;
            }
            catch (InvalidParameterValueException invalidParameterValueException) {
                printWriter.print(Errors.format(91, invalidParameterValueException.getParameterName()));
                printWriter.print(' ');
                printWriter.println(invalidParameterValueException.getLocalizedMessage());
                continue;
            }
            writer.write(string);
            writer.write(this.format(object));
            writer.write(string);
            writer.write(string);
            writer.flush();
        }
        return;
    }

    public String getWarning() {
        if (this.formatter != null && this.formatter.isInvalidWKT()) {
            if (this.formatter.warning != null) {
                return this.formatter.warning;
            }
            return Errors.format(90, this.formatter.getUnformattableClass());
        }
        return null;
    }

    private static void reportError(PrintWriter printWriter, String string, int n) {
        boolean bl;
        string = string.replace('\r', ' ').replace('\n', ' ');
        int n2 = string.length();
        int n3 = n - 40;
        int n4 = n2 - 80;
        boolean bl2 = bl = Math.max(n3, 0) < n4;
        if (!bl) {
            n3 = n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        n2 = Math.min(n2, n3 + 80);
        if (bl) {
            n2 -= 3;
        }
        if (n3 != 0) {
            printWriter.print("...");
            n += 3;
            n3 += 3;
        }
        printWriter.print(string.substring(n3, n2));
        if (bl) {
            printWriter.println("...");
        } else {
            printWriter.println();
        }
        printWriter.print(Utilities.spaces(n - n3));
        printWriter.println('^');
    }

    public static Class<?> getClassOf(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim().toUpperCase(Locale.US);
        Class<?> clazz = TYPES.get(string);
        assert (clazz == null || clazz.equals(MathTransform.class) || string.equals(WKTFormat.getNameOf(clazz))) : clazz;
        return clazz;
    }

    public static String getNameOf(Class<?> clazz) {
        if (clazz != null) {
            for (Map.Entry<String, Class<?>> entry : TYPES.entrySet()) {
                Class<?> clazz2 = entry.getValue();
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    static {
        LinkedHashMap linkedHashMap = new LinkedHashMap(25);
        linkedHashMap.put("GEOGCS", GeographicCRS.class);
        linkedHashMap.put("PROJCS", ProjectedCRS.class);
        linkedHashMap.put("GEOCCS", GeocentricCRS.class);
        linkedHashMap.put("VERT_CS", VerticalCRS.class);
        linkedHashMap.put("LOCAL_CS", EngineeringCRS.class);
        linkedHashMap.put("COMPD_CS", CompoundCRS.class);
        linkedHashMap.put("FITTED_CS", DerivedCRS.class);
        linkedHashMap.put("AXIS", CoordinateSystemAxis.class);
        linkedHashMap.put("PRIMEM", PrimeMeridian.class);
        linkedHashMap.put("TOWGS84", BursaWolfParameters.class);
        linkedHashMap.put("SPHEROID", Ellipsoid.class);
        linkedHashMap.put("VERT_DATUM", VerticalDatum.class);
        linkedHashMap.put("LOCAL_DATUM", EngineeringDatum.class);
        linkedHashMap.put("DATUM", GeodeticDatum.class);
        linkedHashMap.put("PARAM_MT", MathTransform.class);
        linkedHashMap.put("CONCAT_MT", MathTransform.class);
        linkedHashMap.put("INVERSE_MT", MathTransform.class);
        linkedHashMap.put("PASSTHROUGH_MT", MathTransform.class);
        TYPES = linkedHashMap;
    }
}

