/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.geotoolkit.math.Vector;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;

final class ArrayVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 3496467575389288163L;
    private final Object array;

    public ArrayVector(Object object) {
        this.array = object;
    }

    @Override
    public Class<? extends Number> getElementType() {
        return Classes.primitiveToWrapper(this.array.getClass().getComponentType()).asSubclass(Number.class);
    }

    @Override
    public int size() {
        return Array.getLength(this.array);
    }

    @Override
    public boolean isNaN(int n) throws IndexOutOfBoundsException {
        Number number = this.get(n);
        return number == null || Double.isNaN(number.doubleValue());
    }

    @Override
    public double doubleValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getDouble(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    @Override
    public float floatValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getFloat(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    @Override
    public long longValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getLong(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    @Override
    public int intValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getInt(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    @Override
    public short shortValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getShort(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    @Override
    public byte byteValue(int n) throws ArrayIndexOutOfBoundsException, ClassCastException {
        try {
            return Array.getByte(this.array, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.cantConvert(illegalArgumentException);
        }
    }

    private ClassCastException cantConvert(IllegalArgumentException illegalArgumentException) {
        ClassCastException classCastException = new ClassCastException(Errors.format(22, this.array.getClass().getComponentType()));
        classCastException.initCause(illegalArgumentException);
        return classCastException;
    }

    @Override
    public Number get(int n) throws ArrayIndexOutOfBoundsException {
        return (Number)Array.get(this.array, n);
    }

    @Override
    public Number set(int n, Number number) throws ArrayIndexOutOfBoundsException, ArrayStoreException {
        Number number2 = (Number)Array.get(this.array, n);
        try {
            Array.set(this.array, n, number);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArrayStoreException arrayStoreException = new ArrayStoreException(Errors.format(22, Classes.getClass(number)));
            arrayStoreException.initCause(illegalArgumentException);
            throw arrayStoreException;
        }
        return number2;
    }
}

