/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.io.Serializable;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.Point3d;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.Utilities;

public class Plane
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2956201711131316723L;
    public double c;
    public double cx;
    public double cy;

    public final double z(double d, double d2) {
        return this.c + this.cx * d + this.cy * d2;
    }

    public final double y(double d, double d2) {
        return (d2 - (this.c + this.cx * d)) / this.cy;
    }

    public final double x(double d, double d2) {
        return (d2 - (this.c + this.cy * d)) / this.cx;
    }

    public void setPlane(Point3d point3d, Point3d point3d2, Point3d point3d3) throws ArithmeticException {
        double d = point3d2.x * point3d3.y - point3d3.x * point3d2.y;
        double d2 = point3d3.x * point3d.y - point3d.x * point3d3.y;
        double d3 = point3d.x * point3d2.y - point3d2.x * point3d.y;
        double d4 = d + d2 + d3;
        if (d4 == 0.0) {
            throw new ArithmeticException("Points are colinear.");
        }
        this.c = (d * point3d.z + d2 * point3d2.z + d3 * point3d3.z) / d4;
        this.cx = ((point3d2.y - point3d3.y) * point3d.z + (point3d3.y - point3d.y) * point3d2.z + (point3d.y - point3d2.y) * point3d3.z) / d4;
        this.cy = ((point3d3.x - point3d2.x) * point3d.z + (point3d.x - point3d3.x) * point3d2.z + (point3d2.x - point3d.x) * point3d3.z) / d4;
    }

    public double fit(double[] dArray, double[] dArray2, double[] dArray3) throws MismatchedSizeException {
        int n = dArray3.length;
        if (n != dArray.length || n != dArray2.length) {
            throw new MismatchedSizeException();
        }
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d17;
            double d18;
            double d19 = dArray[i];
            if (Double.isNaN(d19) || Double.isNaN(d18 = dArray2[i]) || Double.isNaN(d17 = dArray3[i])) continue;
            double d20 = d19 * d19;
            double d21 = d18 * d18;
            double d22 = d19 * d18;
            double d23 = d17 * d19;
            double d24 = d17 * d18;
            d2 = d19 + (d - (d += (d19 += d2)));
            d4 = d18 + (d3 - (d3 += (d18 += d4)));
            d6 = d17 + (d5 - (d5 += (d17 += d6)));
            d8 = d20 + (d7 - (d7 += (d20 += d8)));
            d10 = d21 + (d9 - (d9 += (d21 += d10)));
            d12 = d22 + (d11 - (d11 += (d22 += d12)));
            d14 = d23 + (d13 - (d13 += (d23 += d14)));
            d16 = d24 + (d15 - (d15 += (d24 += d16)));
            ++n2;
        }
        double d25 = d13 - d5 * d / (double)n2;
        double d26 = d15 - d5 * d3 / (double)n2;
        double d27 = d7 - d * d / (double)n2;
        double d28 = d11 - d * d3 / (double)n2;
        double d29 = d9 - d3 * d3 / (double)n2;
        double d30 = d28 * d28 - d27 * d29;
        this.cy = (d25 * d28 - d26 * d27) / d30;
        this.cx = (d26 * d28 - d25 * d29) / d30;
        this.c = (d5 - (this.cx * d + this.cy * d3)) / (double)n2;
        d /= (double)n2;
        d3 /= (double)n2;
        d5 /= (double)n2;
        double d31 = 0.0;
        double d32 = 0.0;
        double d33 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d34;
            double d35 = dArray3[i] - d5;
            if (Double.isNaN(d35) || Double.isNaN(d34 = this.cx * (dArray[i] - d) + this.cy * (dArray2[i] - d3))) continue;
            d31 += d35 * d35;
            d32 += d34 * d34;
            d33 += d35 * d34;
        }
        return d33 / Math.sqrt(d31 * d32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("z(x,y)= ");
        if (this.c == 0.0 && this.cx == 0.0 && this.cy == 0.0) {
            stringBuilder.append(0);
        } else {
            if (this.c != 0.0) {
                stringBuilder.append(this.c).append(" + ");
            }
            if (this.cx != 0.0) {
                stringBuilder.append(this.cx).append("*x");
                if (this.cy != 0.0) {
                    stringBuilder.append(" + ");
                }
            }
            if (this.cy != 0.0) {
                stringBuilder.append(this.cy).append("*y");
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            Plane plane = (Plane)object;
            return Utilities.equals(this.c, plane.c) && Utilities.equals(this.cx, plane.cx) && Utilities.equals(this.cy, plane.cy);
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.c) + 31L * (Double.doubleToLongBits(this.cx) + 31L * Double.doubleToLongBits(this.cy));
        return (int)l ^ (int)(l >>> 32) ^ 0x2C6251F3;
    }

    @Override
    public Plane clone() {
        try {
            return (Plane)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }
}

