/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.io.Console;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.util.InternationalString;

public class Statistics
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -22884277805533726L;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private double sum = 0.0;
    private double sum2 = 0.0;
    private transient double lowBits;
    private transient double lowBits2;
    private int n = 0;
    private int nNaN = 0;

    public void reset() {
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.sum = 0.0;
        this.sum2 = 0.0;
        this.lowBits = 0.0;
        this.lowBits2 = 0.0;
        this.n = 0;
        this.nNaN = 0;
    }

    public void add(double d) {
        if (!Double.isNaN(d)) {
            if (!(this.min <= d)) {
                this.min = d;
            }
            if (!(this.max >= d)) {
                this.max = d;
            }
            double d2 = d + this.lowBits;
            this.lowBits = d2 + (this.sum - (this.sum += d2));
            d *= d;
            d2 = d + this.lowBits2;
            this.lowBits2 = d2 + (this.sum2 - (this.sum2 += d2));
            ++this.n;
        } else {
            ++this.nNaN;
        }
    }

    public void add(long l) {
        double d = l;
        if (!(this.min <= d)) {
            this.min = d;
        }
        if (!(this.max >= d)) {
            this.max = d;
        }
        double d2 = d + this.lowBits;
        this.lowBits = d2 + (this.sum - (this.sum += d2));
        d *= d;
        d2 = d + this.lowBits2;
        this.lowBits2 = d2 + (this.sum2 - (this.sum2 += d2));
        ++this.n;
    }

    public void add(Statistics statistics) {
        if (statistics != null) {
            if (Double.isNaN(this.min) || statistics.min < this.min) {
                this.min = statistics.min;
            }
            if (Double.isNaN(this.max) || statistics.max > this.max) {
                this.max = statistics.max;
            }
            double d = statistics.sum + this.lowBits;
            this.lowBits = d + (this.sum - (this.sum += d)) + statistics.lowBits;
            d = statistics.sum2 + this.lowBits2;
            this.lowBits2 = d + (this.sum2 - (this.sum2 += d)) + statistics.lowBits2;
            this.n += statistics.n;
            this.nNaN += statistics.nNaN;
        }
    }

    public int countNaN() {
        return Math.max(this.nNaN, 0);
    }

    public int count() {
        return this.n;
    }

    public double minimum() {
        return this.min;
    }

    public double maximum() {
        return this.max;
    }

    public double range() {
        return this.max - this.min;
    }

    public double sum() {
        return this.sum;
    }

    public double mean() {
        return this.sum / (double)this.n;
    }

    public double rms() {
        return Math.sqrt(this.sum2 / (double)this.n);
    }

    public double standardDeviation(boolean bl) {
        return Math.sqrt((this.sum2 - this.sum * this.sum / (double)this.n) / (double)(bl ? this.n : this.n - 1));
    }

    public NumberFormat getNumberFormat(Locale locale) {
        double d;
        double d2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((d2 = Math.max(Math.abs(this.min), Math.abs(this.max))) >= 1.0E10 || d2 <= 1.0E-4) {
            return new DecimalFormat("0.00000E00", DecimalFormatSymbols.getInstance(locale));
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        double d3 = this.mean();
        double d4 = Math.min(this.max, d3 + (d = 2.0 * this.standardDeviation(true))) - Math.max(this.min, d3 - d);
        double d5 = Math.floor(Math.log10(d4));
        if (!Double.isNaN(d5)) {
            int n = Math.max(5 - (int)d5, 0);
            numberFormat.setMinimumFractionDigits(n);
            numberFormat.setMaximumFractionDigits(n);
        }
        return numberFormat;
    }

    public final String toString() {
        return this.toString(null, false);
    }

    public String toString(Locale locale, boolean bl) {
        Object object;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat numberFormat = NumberFormat.getIntegerInstance(locale);
        NumberFormat numberFormat2 = this.getNumberFormat(locale);
        String[] stringArray = new String[6];
        for (int i = 0; i < stringArray.length; ++i) {
            object = this.value(i);
            NumberFormat numberFormat3 = Classes.isInteger(object.getClass()) ? numberFormat : numberFormat2;
            stringArray[i] = numberFormat3.format(this.value(i));
        }
        String string = Statistics.toString(locale, stringArray);
        if (!bl) {
            object = new TableWriter(null, 1);
            ((TableWriter)object).write(string);
            ((TableWriter)object).setColumnAlignment(1, 2);
            string = ((TableWriter)object).toString();
        }
        return string;
    }

    private static String toString(Locale locale, String[] stringArray) {
        return Descriptions.getResources(locale).getString(7, stringArray);
    }

    private Number value(int n) {
        switch (n) {
            case 0: {
                return this.count();
            }
            case 1: {
                return this.minimum();
            }
            case 2: {
                return this.maximum();
            }
            case 3: {
                return this.mean();
            }
            case 4: {
                return this.rms();
            }
            case 5: {
                return this.standardDeviation(false);
            }
        }
        throw new AssertionError(n);
    }

    public static void printTable(CharSequence[] charSequenceArray, Statistics[] statisticsArray, Locale locale) {
        Console console = System.console();
        Writer writer = console != null ? console.writer() : new OutputStreamWriter(System.out);
        try {
            Statistics.writeTable(writer, charSequenceArray, statisticsArray, locale);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static void writeTable(Writer writer, CharSequence[] charSequenceArray, Statistics[] statisticsArray, Locale locale) throws IOException {
        int n;
        CharSequence charSequence;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        TableWriter tableWriter = new TableWriter(writer, " \u2502 ");
        tableWriter.nextLine('\u2500');
        if (charSequenceArray != null) {
            tableWriter.nextColumn();
            int n2 = Math.min(statisticsArray.length, charSequenceArray.length);
            for (int i = 0; i < n2; ++i) {
                charSequence = charSequenceArray[i];
                if (charSequence != null) {
                    if (charSequence instanceof InternationalString) {
                        charSequence = ((InternationalString)charSequence).toString(locale);
                    }
                    tableWriter.write(((Object)charSequence).toString());
                }
                tableWriter.nextColumn();
            }
            tableWriter.nextLine();
            tableWriter.nextLine('\u2500');
        }
        NumberFormat numberFormat = NumberFormat.getIntegerInstance(locale);
        NumberFormat[] numberFormatArray = new NumberFormat[statisticsArray.length];
        charSequence = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        String[] stringArray = new String[6];
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < statisticsArray.length; ++i) {
                Number number;
                Statistics statistics = statisticsArray[i];
                if (n == 0) {
                    tableWriter.setColumnAlignment(i + 1, 2);
                    numberFormatArray[i] = statistics.getNumberFormat(locale);
                }
                if (i != 0) {
                    ((StringBuffer)charSequence).append('\t');
                }
                NumberFormat numberFormat2 = Classes.isInteger((number = statistics.value(n)).getClass()) ? numberFormat : numberFormatArray[i];
                numberFormat2.format(number, (StringBuffer)charSequence, fieldPosition);
            }
            stringArray[n] = ((StringBuffer)charSequence).toString();
            ((StringBuffer)charSequence).setLength(0);
        }
        tableWriter.write(Statistics.toString(locale, stringArray));
        for (n = 1; n <= statisticsArray.length; ++n) {
            tableWriter.setColumnAlignment(n, 2);
        }
        tableWriter.nextLine('\u2500');
        tableWriter.flush();
    }

    @Override
    public Statistics clone() {
        try {
            return (Statistics)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.min) + 31L * (Double.doubleToLongBits(this.max) + 31L * (Double.doubleToLongBits(this.sum) + 31L * Double.doubleToLongBits(this.sum2)));
        return (int)l ^ (int)(l >>> 32) ^ this.n;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            Statistics statistics = (Statistics)object;
            return this.n == statistics.n && Utilities.equals(this.min, statistics.min) && Utilities.equals(this.max, statistics.max) && Utilities.equals(this.sum, statistics.sum) && Utilities.equals(this.sum2, statistics.sum2);
        }
        return false;
    }

    public static class Delta
    extends Statistics {
        private static final long serialVersionUID = 3464306833883333219L;
        private Statistics delta;
        private double last = Double.NaN;
        private long lastAsLong;

        public Delta() {
            this.delta = new Statistics();
            this.delta.nNaN = -1;
        }

        public Delta(Statistics statistics) {
            this.delta = statistics;
            statistics.reset();
            statistics.nNaN = -1;
        }

        public Statistics getDeltaStatistics() {
            return this.delta;
        }

        @Override
        public void reset() {
            super.reset();
            this.delta.reset();
            this.delta.nNaN = -1;
            this.last = Double.NaN;
            this.lastAsLong = 0L;
        }

        @Override
        public void add(double d) {
            super.add(d);
            this.delta.add(d - this.last);
            this.last = d;
            this.lastAsLong = (long)d;
        }

        @Override
        public void add(long l) {
            super.add(l);
            if (this.last == (double)this.lastAsLong) {
                this.delta.add(l - this.lastAsLong);
            } else {
                this.delta.add((double)l - this.last);
            }
            this.last = l;
            this.lastAsLong = l;
        }

        @Override
        public void add(Statistics statistics) throws ClassCastException {
            if (statistics != null) {
                Delta delta = (Delta)statistics;
                if (delta.delta.nNaN >= 0) {
                    this.delta.add(delta.delta);
                    this.last = delta.last;
                    this.lastAsLong = delta.lastAsLong;
                    super.add(statistics);
                }
            }
        }

        @Override
        public Delta clone() {
            Delta delta = (Delta)super.clone();
            delta.delta = delta.delta.clone();
            return delta;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && this.delta.equals(((Delta)object).delta);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.delta.hashCode();
        }
    }
}

