/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.awt.geom.Line2D;
import java.io.Serializable;
import javax.vecmath.MismatchedSizeException;
import org.geotoolkit.math.Vector;
import org.geotoolkit.math.XMath;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.XArrays;

public class VectorPair
implements Serializable {
    private static final long serialVersionUID = 8330893190189236019L;
    protected Vector X;
    protected Vector Y;

    public VectorPair(Vector vector, Vector vector2) {
        this.X = vector;
        VectorPair.ensureNonNull("X", this.X);
        this.Y = vector2;
        VectorPair.ensureNonNull("Y", this.Y);
    }

    private static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, string));
        }
    }

    public Vector getX() {
        return this.X;
    }

    public Vector getY() {
        return this.Y;
    }

    public int length() throws MismatchedSizeException {
        int n = this.Y.size();
        if (n != this.X.size()) {
            throw new MismatchedSizeException(Errors.format(98));
        }
        return n;
    }

    public void omitColinearPoints(double d, double d2) throws MismatchedSizeException {
        int n = this.length();
        double d3 = d2 / d;
        if (!Double.isNaN(d3)) {
            Vector vector = this.X;
            Vector vector2 = this.Y;
            int[] nArray = null;
            int n2 = 0;
            if (n >= 3) {
                d2 *= d2;
                double d4 = vector.doubleValue(0) * d3;
                double d5 = vector2.doubleValue(0);
                double d6 = vector.doubleValue(1) * d3;
                double d7 = vector2.doubleValue(1);
                for (int i = 2; i < n; ++i) {
                    double d8;
                    double d9 = vector.doubleValue(i) * d3;
                    double d10 = Line2D.ptSegDistSq(d4, d5, d9, d8 = vector2.doubleValue(i), d6, d7);
                    if (d10 <= d2) {
                        if (nArray == null) {
                            nArray = new int[n - 1];
                            while (n2 < i) {
                                nArray[n2] = n2++;
                            }
                        }
                        nArray[n2 - 1] = i;
                    } else {
                        if (nArray != null) {
                            nArray[n2++] = i;
                        }
                        d4 = d6;
                        d5 = d7;
                    }
                    d6 = d9;
                    d7 = d8;
                }
            }
            if (nArray != null) {
                nArray = XArrays.resize(nArray, n2);
                this.X = vector.view(nArray);
                this.Y = vector2.view(nArray);
            }
        }
    }

    public void makeStepwise(int n) throws MismatchedSizeException {
        Vector vector = this.X;
        Vector vector2 = this.Y;
        int n2 = vector2.size();
        if (n2 + 1 != vector.size()) {
            throw new MismatchedSizeException();
        }
        int[] nArray = new int[n2 * 2];
        int[] nArray2 = new int[n2 * 2];
        if (n2 != 0) {
            double d;
            double d2;
            int n3;
            boolean bl = false;
            double d3 = vector.doubleValue(0);
            double d4 = vector2.doubleValue(0);
            int n4 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                if (n != 0) {
                    if (n3 + 1 == n2) {
                        bl = false;
                    } else {
                        boolean bl2;
                        int n5;
                        d2 = vector.doubleValue(n3 + 1);
                        d = vector2.doubleValue(n3 + 1);
                        int n6 = d2 > d3 ? 1 : (n5 = d2 < d3 ? -1 : 0);
                        if (n5 != 0 && ((bl2 = n >= 0 ^ n5 < 0 ^ bl) ? d > d4 : d < d4)) {
                            bl = !bl;
                        }
                        d3 = d2;
                        d4 = d;
                    }
                }
                nArray[n4] = n3;
                nArray2[n4++] = n3;
                nArray[n4] = bl ? n3 : n3 + 1;
                nArray2[n4++] = bl ? n3 + 1 : n3;
            }
            assert (XArrays.isSorted(nArray, false));
            assert (XArrays.isSorted(nArray2, false));
            if (Math.abs(n) >= 2) {
                n = XMath.sgn(n);
                n4 = n3 = nArray.length;
                while (--n4 >= 2) {
                    if (nArray[n4] != nArray[n4 - 2]) continue;
                    d4 = vector2.doubleValue(nArray2[n4 - 2]) * (double)n;
                    d2 = vector2.doubleValue(nArray2[n4 - 1]) * (double)n;
                    if (!(d2 < Math.min(d4, d = vector2.doubleValue(nArray2[n4]) * (double)n))) continue;
                    System.arraycopy(nArray, n4, nArray, n4 - 1, n3 - n4);
                    System.arraycopy(nArray2, n4, nArray2, n4 - 1, n3 - n4);
                    --n3;
                }
                nArray = XArrays.resize(nArray, n3);
                nArray2 = XArrays.resize(nArray2, n3);
            }
        }
        this.X = vector.view(nArray);
        this.Y = vector2.view(nArray2);
    }
}

