/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.measure;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.geotoolkit.geometry.TransformedDirectPosition;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.measure.Angle;
import org.geotoolkit.measure.AngleFormat;
import org.geotoolkit.measure.Latitude;
import org.geotoolkit.measure.Longitude;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.converter.Classes;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.operation.TransformException;

public class CoordinateFormat
extends Format {
    private static final long serialVersionUID = 8324486673169133932L;
    private CoordinateReferenceSystem crs;
    private String separator;
    private final Locale locale;
    private transient Format[] formats;
    private DateFormat dateFormat;
    private AngleFormat angleFormat;
    private NumberFormat numberFormat;
    private transient UnitFormat unitFormat;
    private transient String[] unitSymbols;
    private transient UnitConverter[] toFormatUnit;
    private transient boolean[] negate;
    private transient long[] epochs;
    private transient byte[] types;
    private static final byte LONGITUDE = 1;
    private static final byte LATITUDE = 2;
    private static final byte ANGLE = 3;
    private static final byte DATE = 4;
    private static final byte TIME = 5;
    private transient FieldPosition dummy = new FieldPosition(0);
    private transient TransformedDirectPosition transform;

    public CoordinateFormat() {
        this(Locale.getDefault());
    }

    public CoordinateFormat(Locale locale) {
        this(locale, DefaultGeographicCRS.WGS84);
    }

    public CoordinateFormat(Locale locale, CoordinateReferenceSystem coordinateReferenceSystem) {
        CoordinateFormat.ensureNonNull("locale", locale);
        this.locale = locale;
        this.crs = coordinateReferenceSystem;
        this.separator = " ";
        this.initialize();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.crs = coordinateReferenceSystem;
        if (!CRS.equalsIgnoreMetadata(this.crs, this.crs)) {
            this.initialize();
        }
    }

    private void initialize() {
        int n;
        CoordinateSystem coordinateSystem;
        if (this.crs != null) {
            coordinateSystem = this.crs.getCoordinateSystem();
            n = coordinateSystem.getDimension();
        } else {
            coordinateSystem = null;
            n = 1;
        }
        this.types = new byte[n];
        this.formats = new Format[n];
        this.toFormatUnit = new UnitConverter[n];
        this.negate = new boolean[n];
        this.epochs = null;
        this.unitSymbols = null;
        if (this.crs == null) {
            this.formats[0] = this.getNumberFormat();
            this.transform = null;
            return;
        }
        if (this.transform != null) {
            if (this.transform.getDimension() == n) {
                this.transform.setCoordinateReferenceSystem(this.crs);
            } else {
                this.transform = null;
            }
        }
        for (int i = 0; i < n; ++i) {
            String string;
            boolean bl;
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            Unit<Quantity> unit = coordinateSystemAxis.getUnit();
            AxisDirection axisDirection = coordinateSystemAxis.getDirection();
            boolean bl2 = bl = axisDirection != (axisDirection = axisDirection.absolute());
            if (Units.isAngular(unit)) {
                int n2 = AxisDirection.EAST.equals(axisDirection) ? 1 : (AxisDirection.NORTH.equals(axisDirection) ? 2 : 3);
                this.types[i] = n2;
                this.formats[i] = this.getAngleFormat();
                this.toFormatUnit[i] = unit.getConverterTo(NonSI.DEGREE_ANGLE);
                this.negate[i] = bl;
                continue;
            }
            if (Units.isTemporal(unit)) {
                Datum datum = CRSUtilities.getDatum(CRSUtilities.getSubCRS(this.crs, i, i + 1));
                if (datum instanceof TemporalDatum) {
                    if (this.epochs == null) {
                        this.epochs = new long[n];
                    }
                    this.types[i] = 4;
                    this.formats[i] = this.getDateFormat();
                    this.toFormatUnit[i] = unit.getConverterTo(Units.MILLISECOND);
                    this.epochs[i] = ((TemporalDatum)datum).getOrigin().getTime();
                    this.negate[i] = bl;
                    continue;
                }
                this.types[i] = 5;
            }
            if (unit != null && (string = this.getUnitFormat().format(unit).trim()).length() != 0) {
                if (this.unitSymbols == null) {
                    this.unitSymbols = new String[n];
                }
                this.unitSymbols[i] = string;
            }
            this.formats[i] = this.getNumberFormat();
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        CoordinateFormat.ensureNonNull("separator", string);
        this.separator = string;
    }

    public String getNumberPattern() {
        NumberFormat numberFormat = this.getNumberFormat();
        if (numberFormat instanceof DecimalFormat) {
            return ((DecimalFormat)numberFormat).toPattern();
        }
        return null;
    }

    public void setNumberPattern(String string) {
        CoordinateFormat.ensureNonNull("pattern", string);
        NumberFormat numberFormat = this.getNumberFormat();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).applyPattern(string);
        }
    }

    public String getAnglePattern() {
        return this.getAngleFormat().toPattern();
    }

    public void setAnglePattern(String string) {
        CoordinateFormat.ensureNonNull("pattern", string);
        this.getAngleFormat().applyPattern(string);
    }

    public String getDatePattern() {
        DateFormat dateFormat = this.getDateFormat();
        if (dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)dateFormat).toPattern();
        }
        return null;
    }

    public void setDatePattern(String string) {
        CoordinateFormat.ensureNonNull("pattern", string);
        DateFormat dateFormat = this.getDateFormat();
        if (dateFormat instanceof SimpleDateFormat) {
            ((SimpleDateFormat)dateFormat).applyPattern(string);
        }
    }

    public TimeZone getTimeZone() {
        return this.getDateFormat().getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        CoordinateFormat.ensureNonNull("timezone", timeZone);
        this.getDateFormat().setTimeZone(timeZone);
    }

    public Format getFormat(int n) throws IndexOutOfBoundsException {
        return this.formats[n];
    }

    private DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateInstance(2, this.locale);
        }
        return this.dateFormat;
    }

    private AngleFormat getAngleFormat() {
        if (this.angleFormat == null) {
            this.angleFormat = new AngleFormat("DD\u00b0MM.m'", this.locale);
        }
        return this.angleFormat;
    }

    private NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getNumberInstance(this.locale);
        }
        return this.numberFormat;
    }

    private UnitFormat getUnitFormat() {
        if (this.unitFormat == null) {
            this.unitFormat = UnitFormat.getInstance(this.locale);
        }
        return this.unitFormat;
    }

    public String format(DirectPosition directPosition) {
        return this.format(directPosition, new StringBuffer(), null).toString();
    }

    public StringBuffer format(DirectPosition directPosition, StringBuffer stringBuffer, FieldPosition fieldPosition) throws IllegalArgumentException {
        CoordinateFormat.ensureNonNull("point", directPosition);
        CoordinateFormat.ensureNonNull("toAppendTo", stringBuffer);
        int n = directPosition.getDimension();
        if (n != this.formats.length && this.crs != null) {
            throw new MismatchedDimensionException(Errors.format(101, "point", n, this.formats.length));
        }
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem, this.crs) && coordinateReferenceSystem != null && this.crs != null) {
            if (this.transform == null) {
                this.transform = new TransformedDirectPosition(null, this.crs, null);
            }
            try {
                this.transform.transform(directPosition);
                directPosition = this.transform;
            }
            catch (TransformException transformException) {
                throw new IllegalArgumentException(Errors.format(67), transformException);
            }
        }
        for (int i = 0; i < n; ++i) {
            String string;
            Comparable<Double> comparable;
            UnitConverter unitConverter;
            double d = directPosition.getOrdinate(i);
            int n2 = Math.min(i, this.formats.length - 1);
            if (this.negate[n2]) {
                d = -d;
            }
            if ((unitConverter = this.toFormatUnit[n2]) != null) {
                d = unitConverter.convert(d);
            }
            byte by = this.types[n2];
            switch (by) {
                default: {
                    comparable = d;
                    break;
                }
                case 1: {
                    comparable = new Longitude(d);
                    break;
                }
                case 2: {
                    comparable = new Latitude(d);
                    break;
                }
                case 3: {
                    comparable = new Angle(d);
                    break;
                }
                case 4: {
                    comparable = new Date(this.epochs[n2] + Math.round(d));
                }
            }
            if (i != 0) {
                stringBuffer.append(this.separator);
            }
            this.formats[n2].format(comparable, stringBuffer, this.dummy);
            if (this.unitSymbols == null || (string = this.unitSymbols[n2]) == null) continue;
            stringBuffer.append('\u00a0').append(string);
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) throws IllegalArgumentException {
        if (object instanceof DirectPosition) {
            return this.format((DirectPosition)object, stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException(Errors.format(66, Classes.getClass(object), DirectPosition.class));
    }

    @Override
    public DirectPosition parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException("DirectPosition parsing not yet implemented.");
    }

    private static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, string));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.dummy = new FieldPosition(0);
        this.initialize();
    }
}

