/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.measure;

import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.geotoolkit.measure.SexagesimalConverter;

public final class Units {
    public static final Unit<Duration> MILLISECOND = SI.MILLI(SI.SECOND);
    public static final Unit<Angle> SEXAGESIMAL_DMS = NonSI.DEGREE_ANGLE.transform(SexagesimalConverter.FRACTIONAL.inverse()).asType(Angle.class);
    public static final Unit<Angle> DEGREE_MINUTE_SECOND = NonSI.DEGREE_ANGLE.transform(SexagesimalConverter.INTEGER.inverse()).asType(Angle.class);
    public static final Unit<Dimensionless> PPM = Unit.ONE.times(1.0E-6);

    private Units() {
    }

    public static boolean isTemporal(Unit<?> unit) {
        return unit != null && unit.getStandardUnit().equals(SI.SECOND);
    }

    public static boolean isLinear(Unit<?> unit) {
        return unit != null && unit.getStandardUnit().equals(SI.METRE);
    }

    public static boolean isAngular(Unit<?> unit) {
        return unit != null && unit.getStandardUnit().equals(SI.RADIAN);
    }

    public static boolean isScale(Unit<?> unit) {
        return unit != null && unit.getStandardUnit().equals(Unit.ONE);
    }

    static {
        UnitFormat unitFormat = UnitFormat.getInstance();
        unitFormat.label(SEXAGESIMAL_DMS, "D.MS");
        unitFormat.label(DEGREE_MINUTE_SECOND, "DMS");
        unitFormat.label(PPM, "ppm");
    }
}

