/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.text.ParseException;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.tree.TreeModel;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.metadata.UnmodifiableMetadataException;
import org.geotoolkit.util.logging.Logging;

public abstract class AbstractMetadata {
    protected static final Logger LOGGER = Logging.getLogger(AbstractMetadata.class);
    private transient int hashCode;
    private transient Map<String, Object> asMap;

    protected AbstractMetadata() {
    }

    protected AbstractMetadata(Object object) throws ClassCastException, UnmodifiableMetadataException {
        this.getStandard().shallowCopy(object, this, true);
    }

    public abstract MetadataStandard getStandard();

    public Class<?> getInterface() {
        return this.getStandard().getInterface(this.getClass());
    }

    boolean isModifiable() {
        return this.getStandard().isModifiable(this.getClass());
    }

    void invalidate() {
        assert (Thread.holdsLock(this));
        this.hashCode = 0;
    }

    public synchronized Map<String, Object> asMap() {
        if (this.asMap == null) {
            this.asMap = this.getStandard().asMap(this);
        }
        return this.asMap;
    }

    public synchronized TreeModel asTree() {
        return this.getStandard().asTree(this);
    }

    public synchronized void parse(TreeModel treeModel) throws ParseException {
        this.getStandard().parse(treeModel, this);
    }

    public boolean equals(Object object) {
        int n;
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        int n2 = this.hashCode;
        if (n2 != 0 && (n = ((AbstractMetadata)object).hashCode) != 0 && n2 != n) {
            return false;
        }
        MetadataStandard metadataStandard = this.getStandard();
        return metadataStandard.shallowEquals(this, object, false);
    }

    public synchronized int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = this.getStandard().hashCode(this);
            if (!this.isModifiable()) {
                this.hashCode = n;
            }
        }
        return n;
    }

    public synchronized String toString() {
        return this.getStandard().toString(this);
    }
}

