/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.NameMap;
import org.geotoolkit.metadata.NullValuePolicy;
import org.geotoolkit.metadata.PropertyAccessor;
import org.geotoolkit.metadata.PropertyMap;
import org.geotoolkit.metadata.PropertyTree;
import org.geotoolkit.metadata.RestrictionMap;
import org.geotoolkit.metadata.TypeMap;
import org.geotoolkit.metadata.TypeValuePolicy;
import org.geotoolkit.metadata.UnmodifiableMetadataException;
import org.geotoolkit.metadata.ValueRestriction;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.logging.Logging;

public final class MetadataStandard {
    public static final MetadataStandard ISO_19111 = new MetadataStandard("org.opengis.referencing.");
    public static final MetadataStandard ISO_19115 = new MetadataStandard("org.opengis.metadata.", "org.geotoolkit.metadata.iso.", new String[]{"Default", "Abstract"});
    public static final MetadataStandard ISO_19119 = new MetadataStandard("org.opengis.service.");
    private final String interfacePackage;
    private final String implementationPackage;
    private final String[] prefix;
    private final Map<Class<?>, PropertyAccessor> accessors = new HashMap();
    private final Map<Class<?>, Class<?>> implementations;
    private final ThreadLocal<PropertyTree> treeBuilders = new ThreadLocal<PropertyTree>(){

        @Override
        protected PropertyTree initialValue() {
            return new PropertyTree(MetadataStandard.this);
        }
    };

    public MetadataStandard(String string) {
        this(string, null, null);
    }

    private MetadataStandard(String string, String string2, String[] stringArray) {
        if (!string.endsWith(".")) {
            string = string + '.';
        }
        if (string2 != null) {
            if (!string2.endsWith(".")) {
                string2 = string2 + '.';
            }
            this.implementations = new HashMap();
        } else {
            this.implementations = null;
        }
        this.interfacePackage = string;
        this.implementationPackage = string2;
        this.prefix = stringArray;
    }

    private PropertyAccessor getAccessor(Class<?> clazz) throws ClassCastException {
        PropertyAccessor propertyAccessor = this.getAccessorOptional(clazz);
        if (propertyAccessor == null) {
            throw new ClassCastException(Errors.format(198, clazz.getCanonicalName()));
        }
        return propertyAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PropertyAccessor getAccessorOptional(Class<?> clazz) {
        Map<Class<?>, PropertyAccessor> map = this.accessors;
        synchronized (map) {
            Class<?> clazz2;
            PropertyAccessor propertyAccessor = this.accessors.get(clazz);
            if (propertyAccessor == null && (clazz2 = this.getType(clazz)) != null) {
                propertyAccessor = new PropertyAccessor(clazz, clazz2);
                this.accessors.put(clazz, propertyAccessor);
            }
            return propertyAccessor;
        }
    }

    private Class<?> getType(Class<?> clazz) {
        return PropertyAccessor.getType(clazz, this.interfacePackage);
    }

    public boolean isMetadata(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().startsWith(this.interfacePackage)) {
            return true;
        }
        return this.getAccessorOptional(clazz) != null;
    }

    public Class<?> getInterface(Class<?> clazz) throws ClassCastException {
        MetadataStandard.ensureNonNull("implementation", clazz);
        if (clazz.getName().startsWith(this.interfacePackage)) {
            return clazz;
        }
        return this.getAccessor(clazz).type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Class<?> getImplementation(Class<?> clazz) {
        String string;
        if (clazz != null && clazz.isInterface() && this.implementations != null && (string = clazz.getName()).startsWith(this.interfacePackage)) {
            Map<Class<?>, Class<?>> map = this.implementations;
            synchronized (map) {
                Class<?> clazz2 = this.implementations.get(clazz);
                if (clazz2 != null) {
                    return clazz2;
                }
                StringBuilder stringBuilder = new StringBuilder(this.implementationPackage).append(string.substring(this.interfacePackage.length()));
                int n = stringBuilder.lastIndexOf(".") + 1;
                int n2 = 0;
                if (this.prefix != null) {
                    for (String string2 : this.prefix) {
                        string = stringBuilder.replace(n, n + n2, string2).toString();
                        try {
                            clazz2 = Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Logging.recoverableException(MetadataStandard.class, "getImplementation", classNotFoundException);
                            n2 = string2.length();
                            continue;
                        }
                        if (clazz2.isAnnotationPresent(Deprecated.class)) {
                            n2 = string2.length();
                            continue;
                        }
                        this.implementations.put(clazz, clazz2);
                        return clazz2;
                    }
                }
            }
        }
        return clazz;
    }

    public Map<String, Class<?>> asTypeMap(Class<?> clazz, TypeValuePolicy typeValuePolicy, KeyNamePolicy keyNamePolicy) throws ClassCastException {
        MetadataStandard.ensureNonNull("type", clazz);
        MetadataStandard.ensureNonNull("typeValues", (Object)typeValuePolicy);
        MetadataStandard.ensureNonNull("keyNames", (Object)keyNamePolicy);
        clazz = this.getImplementation(clazz);
        return new TypeMap(this.getAccessor(clazz), typeValuePolicy, keyNamePolicy);
    }

    public Map<String, String> asNameMap(Class<?> clazz, KeyNamePolicy keyNamePolicy, KeyNamePolicy keyNamePolicy2) throws ClassCastException {
        MetadataStandard.ensureNonNull("type", clazz);
        MetadataStandard.ensureNonNull("typeValues", (Object)keyNamePolicy);
        MetadataStandard.ensureNonNull("keyNames", (Object)keyNamePolicy2);
        clazz = this.getImplementation(clazz);
        return new NameMap(this.getAccessor(clazz), keyNamePolicy, keyNamePolicy2);
    }

    public Map<String, ValueRestriction> asRestrictionMap(Object object, NullValuePolicy nullValuePolicy, KeyNamePolicy keyNamePolicy) throws ClassCastException {
        Class<?> clazz;
        MetadataStandard.ensureNonNull("metadata", object);
        MetadataStandard.ensureNonNull("content", (Object)nullValuePolicy);
        MetadataStandard.ensureNonNull("keyNames", (Object)keyNamePolicy);
        if (object instanceof Class) {
            clazz = this.getImplementation((Class)object);
            object = null;
        } else {
            clazz = object.getClass();
        }
        return new RestrictionMap(this.getAccessor(clazz), object, nullValuePolicy, keyNamePolicy);
    }

    public Map<String, Object> asMap(Object object, NullValuePolicy nullValuePolicy, KeyNamePolicy keyNamePolicy) throws ClassCastException {
        MetadataStandard.ensureNonNull("metadata", object);
        MetadataStandard.ensureNonNull("content", (Object)nullValuePolicy);
        MetadataStandard.ensureNonNull("keyNames", (Object)keyNamePolicy);
        return new PropertyMap(object, this.getAccessor(object.getClass()), nullValuePolicy, keyNamePolicy);
    }

    public Map<String, Object> asMap(Object object) throws ClassCastException {
        return this.asMap(object, NullValuePolicy.NON_EMPTY, KeyNamePolicy.JAVABEANS_PROPERTY);
    }

    public TreeModel asTree(Object object) throws ClassCastException {
        PropertyTree propertyTree = this.treeBuilders.get();
        return new DefaultTreeModel(propertyTree.asTree(object), true);
    }

    final void parse(TreeModel treeModel, Object object) throws ParseException {
        this.treeBuilders.get().parse((TreeNode)treeModel.getRoot(), object);
    }

    final boolean isModifiable(Class<?> clazz) throws ClassCastException {
        return this.getAccessor(clazz).isModifiable();
    }

    final void freeze(Object object) throws ClassCastException {
        this.getAccessor(object.getClass()).freeze(object);
    }

    public void shallowCopy(Object object, Object object2, boolean bl) throws ClassCastException, UnmodifiableMetadataException {
        MetadataStandard.ensureNonNull("target", object2);
        PropertyAccessor propertyAccessor = this.getAccessor(object2.getClass());
        if (!propertyAccessor.type.isInstance(object)) {
            MetadataStandard.ensureNonNull("source", object);
            throw new ClassCastException(Errors.format(66, object.getClass(), propertyAccessor.type));
        }
        if (!propertyAccessor.shallowCopy(object, object2, bl)) {
            throw new UnmodifiableMetadataException(Errors.format(201));
        }
    }

    public boolean shallowEquals(Object object, Object object2, boolean bl) throws ClassCastException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        PropertyAccessor propertyAccessor = this.getAccessor(object.getClass());
        if (!propertyAccessor.type.equals(this.getType(object2.getClass()))) {
            return false;
        }
        return propertyAccessor.shallowEquals(object, object2, bl);
    }

    public int hashCode(Object object) throws ClassCastException {
        return this.getAccessor(object.getClass()).hashCode(object);
    }

    public String toString(Object object) throws ClassCastException {
        PropertyTree propertyTree = this.treeBuilders.get();
        return PropertyTree.toString(propertyTree.asTree(object));
    }

    private static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, string));
        }
    }
}

