/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.metadata.AbstractMetadata;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.metadata.UnmodifiableMetadataException;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.CheckedArrayList;
import org.geotoolkit.util.collection.CheckedHashSet;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.logging.Logging;
import org.opengis.util.CodeList;

public abstract class ModifiableMetadata
extends AbstractMetadata
implements Cloneable {
    private static final ModifiableMetadata FREEZING = new Null();
    private transient ModifiableMetadata unmodifiable;

    protected ModifiableMetadata() {
    }

    protected ModifiableMetadata(Object object) throws ClassCastException, UnmodifiableMetadataException {
        super(object);
    }

    @Override
    public final boolean isModifiable() {
        return this.unmodifiable != this;
    }

    public synchronized AbstractMetadata unmodifiable() {
        if (this.unmodifiable == null) {
            ModifiableMetadata modifiableMetadata;
            try {
                modifiableMetadata = this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Logging.unexpectedException(LOGGER, cloneNotSupportedException);
                return this;
            }
            modifiableMetadata.freeze();
            this.unmodifiable = modifiableMetadata;
        }
        assert (!this.unmodifiable.isModifiable());
        return this.unmodifiable;
    }

    static Object unmodifiable(Object object) {
        if (object instanceof ModifiableMetadata) {
            return ((ModifiableMetadata)object).unmodifiable();
        }
        if (object instanceof Collection) {
            Collection<Object> collection = (UnmodifiableArrayList<Object>)object;
            boolean bl = collection instanceof Set;
            if (collection.isEmpty()) {
                collection = bl ? Collections.EMPTY_SET : Collections.EMPTY_LIST;
            } else {
                Object[] objectArray = collection.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = ModifiableMetadata.unmodifiable(objectArray[i]);
                }
                collection = UnmodifiableArrayList.wrap(objectArray);
                if (bl) {
                    collection = Collections.unmodifiableSet(new LinkedHashSet<Object>(collection));
                }
            }
            return collection;
        }
        if (object instanceof Map) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            if (linkedHashMap.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            linkedHashMap = new LinkedHashMap(linkedHashMap);
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                entry.setValue(ModifiableMetadata.unmodifiable(entry.getValue()));
            }
            return Collections.unmodifiableMap(linkedHashMap);
        }
        if (object instanceof org.geotoolkit.util.Cloneable) {
            return ((org.geotoolkit.util.Cloneable)object).clone();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void freeze() {
        ModifiableMetadata modifiableMetadata = null;
        try {
            this.unmodifiable = FREEZING;
            this.getStandard().freeze(this);
            modifiableMetadata = this;
        }
        finally {
            this.unmodifiable = modifiableMetadata;
        }
    }

    protected void checkWritePermission() throws UnmodifiableMetadataException {
        assert (Thread.holdsLock(this));
        if (!this.isModifiable()) {
            throw new UnmodifiableMetadataException(Errors.format(201));
        }
        this.invalidate();
    }

    @Override
    final void invalidate() {
        super.invalidate();
        this.unmodifiable = null;
    }

    private static boolean isModifiable(Collection<?> collection) {
        if (!collection.isEmpty()) {
            try {
                collection.clear();
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected final <E> List<E> copyList(Collection<? extends E> collection, List<E> list, Class<E> clazz) throws UnmodifiableMetadataException {
        if (collection != list) {
            if (this.unmodifiable == FREEZING) {
                List list2 = (List)collection;
                assert (!ModifiableMetadata.isModifiable(list2));
                return list2;
            }
            this.checkWritePermission();
            if (collection == null) {
                list = null;
            } else {
                if (list != null) {
                    list.clear();
                } else {
                    list = new MutableList<E>(clazz, collection.size());
                }
                list.addAll(collection);
            }
        }
        return list;
    }

    protected final <E> Set<E> copySet(Collection<? extends E> collection, Set<E> set, Class<E> clazz) throws UnmodifiableMetadataException {
        if (collection != set) {
            if (this.unmodifiable == FREEZING) {
                Set set2 = (Set)collection;
                assert (!ModifiableMetadata.isModifiable(set2));
                return set2;
            }
            this.checkWritePermission();
            if (collection == null) {
                set = null;
            } else {
                if (set != null) {
                    set.clear();
                } else {
                    set = new MutableSet<E>(clazz, collection.size());
                }
                set.addAll(collection);
            }
        }
        return set;
    }

    protected final <E> Collection<E> copyCollection(Collection<? extends E> collection, Collection<E> abstractCollection, Class<E> clazz) throws UnmodifiableMetadataException {
        if (collection != abstractCollection) {
            if (this.unmodifiable == FREEZING) {
                Collection<E> collection2 = collection;
                assert (collection2 instanceof Set == ModifiableMetadata.useSet(clazz)) : clazz;
                assert (!ModifiableMetadata.isModifiable(collection2));
                return collection2;
            }
            this.checkWritePermission();
            if (collection == null) {
                abstractCollection = null;
            } else {
                if (abstractCollection != null) {
                    abstractCollection.clear();
                } else {
                    int n = collection.size();
                    abstractCollection = ModifiableMetadata.useSet(clazz) ? new MutableSet<E>(clazz, n) : new MutableList<E>(clazz, n);
                }
                abstractCollection.addAll(collection);
            }
        }
        return abstractCollection;
    }

    protected final <E> Collection<E> nonNullCollection(Collection<E> collection, Class<E> clazz) {
        assert (Thread.holdsLock(this));
        if (collection != null) {
            assert (collection instanceof Set == ModifiableMetadata.useSet(clazz)) : clazz;
            return collection;
        }
        boolean bl = this.isModifiable();
        if (ModifiableMetadata.useSet(clazz)) {
            if (bl) {
                return new MutableSet<E>(clazz);
            }
            return Collections.emptySet();
        }
        if (bl) {
            return new MutableList<E>(clazz);
        }
        return Collections.emptyList();
    }

    protected final <E> Set<E> nonNullSet(Set<E> set, Class<E> clazz) {
        assert (Thread.holdsLock(this));
        if (set != null) {
            return set;
        }
        if (this.isModifiable()) {
            return new MutableSet<E>(clazz);
        }
        return Collections.emptySet();
    }

    protected final <E> List<E> nonNullList(List<E> list, Class<E> clazz) {
        assert (Thread.holdsLock(this));
        if (list != null) {
            return list;
        }
        if (this.isModifiable()) {
            return new MutableList<E>(clazz);
        }
        return Collections.emptyList();
    }

    private static boolean useSet(Class<?> clazz) {
        return CodeList.class.isAssignableFrom(clazz) || Enum.class.isAssignableFrom(clazz) || String.class.equals(clazz);
    }

    protected ModifiableMetadata clone() throws CloneNotSupportedException {
        return (ModifiableMetadata)super.clone();
    }

    private final class MutableList<E>
    extends CheckedArrayList<E> {
        private static final long serialVersionUID = -5016778173550153002L;

        public MutableList(Class<E> clazz) {
            super(clazz);
        }

        public MutableList(Class<E> clazz, int n) {
            super(clazz, n);
        }

        @Override
        protected Object getLock() {
            return ModifiableMetadata.this;
        }

        @Override
        protected void checkWritePermission() throws UnsupportedOperationException {
            ModifiableMetadata.this.checkWritePermission();
        }
    }

    private final class MutableSet<E>
    extends CheckedHashSet<E> {
        private static final long serialVersionUID = 2337350768744454264L;

        public MutableSet(Class<E> clazz) {
            super(clazz);
        }

        public MutableSet(Class<E> clazz, int n) {
            super(clazz, Utilities.hashMapCapacity(n));
        }

        @Override
        protected Object getLock() {
            return ModifiableMetadata.this;
        }

        @Override
        protected void checkWritePermission() throws UnsupportedOperationException {
            ModifiableMetadata.this.checkWritePermission();
        }
    }

    private static final class Null
    extends ModifiableMetadata {
        private Null() {
        }

        @Override
        public MetadataStandard getStandard() {
            return null;
        }
    }
}

