/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.MetadataMap;
import org.geotoolkit.metadata.NullValuePolicy;
import org.geotoolkit.metadata.PropertyAccessor;
import org.geotoolkit.util.Utilities;

final class PropertyMap
extends MetadataMap<Object> {
    private final Object metadata;
    final NullValuePolicy content;

    PropertyMap(Object object, PropertyAccessor propertyAccessor, NullValuePolicy nullValuePolicy, KeyNamePolicy keyNamePolicy) {
        super(propertyAccessor, keyNamePolicy);
        this.metadata = object;
        this.content = nullValuePolicy;
    }

    @Override
    public boolean isEmpty() {
        return this.accessor.count(this.metadata, 1) == 0;
    }

    @Override
    public int size() {
        return this.accessor.count(this.metadata, Integer.MAX_VALUE);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public Object get(Object object) {
        if (object instanceof String) {
            Object object2 = this.accessor.get(this.accessor.indexOf((String)object), this.metadata);
            switch (this.content) {
                case NON_EMPTY: {
                    if (!PropertyAccessor.isEmpty(object2)) break;
                    return null;
                }
            }
            return object2;
        }
        return null;
    }

    @Override
    public Object put(String string, Object object) throws IllegalArgumentException, ClassCastException {
        return this.accessor.set(this.accessor.requiredIndexOf(string), this.metadata, object, true);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.accessor.set(this.accessor.requiredIndexOf(entry.getKey()), this.metadata, entry.getValue(), false);
        }
    }

    @Override
    public Object remove(Object object) {
        if (object instanceof String) {
            return this.put((String)object, (Object)null);
        }
        return null;
    }

    @Override
    public synchronized Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new Entries();
        }
        return this.entrySet;
    }

    @Override
    final Iterator<Map.Entry<String, Object>> iterator() {
        return new Iter();
    }

    private final class Entries
    extends MetadataMap.Entries {
        Entries() {
        }

        @Override
        public boolean contains(Object object) {
            Map.Entry entry;
            Object k;
            if (object instanceof Map.Entry && (k = (entry = (Map.Entry)object).getKey()) instanceof String) {
                return new Property((String)k).equals(entry);
            }
            return false;
        }
    }

    private final class Iter
    extends MetadataMap.Iter {
        private Property current;
        private Property next;

        Iter() {
            this.move(0);
        }

        private void move(int n) {
            int n2 = PropertyMap.this.accessor.count();
            while (n < n2) {
                boolean bl;
                Object object = PropertyMap.this.accessor.get(n, PropertyMap.this.metadata);
                switch (PropertyMap.this.content) {
                    case ALL: {
                        bl = false;
                        break;
                    }
                    case NON_NULL: {
                        bl = object == null;
                        break;
                    }
                    case NON_EMPTY: {
                        bl = PropertyAccessor.isEmpty(object);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)PropertyMap.this.content);
                    }
                }
                if (!bl) {
                    this.next = new Property(n);
                    return;
                }
                ++n;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<String, Object> next() {
            if (this.next != null) {
                this.current = this.next;
                this.move(this.next.index + 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.setValue((Object)null);
            this.current = null;
        }
    }

    private final class Property
    implements Map.Entry<String, Object> {
        final int index;

        Property(int n) {
            this.index = n;
        }

        Property(String string) {
            this.index = PropertyMap.this.accessor.indexOf(string);
        }

        @Override
        public String getKey() {
            return PropertyMap.this.accessor.name(this.index, PropertyMap.this.keyNames);
        }

        @Override
        public Object getValue() {
            Object object = PropertyMap.this.accessor.get(this.index, PropertyMap.this.metadata);
            switch (PropertyMap.this.content) {
                case NON_EMPTY: {
                    if (!PropertyAccessor.isEmpty(object)) break;
                    return null;
                }
            }
            return object;
        }

        @Override
        public Object setValue(Object object) throws ClassCastException {
            return PropertyMap.this.accessor.set(this.index, PropertyMap.this.metadata, object, true);
        }

        public boolean equals(Map.Entry<?, ?> entry) {
            return Utilities.equals(this.getKey(), entry.getKey()) && Utilities.equals(this.getValue(), entry.getValue());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Map.Entry && this.equals((Map.Entry)object);
        }

        @Override
        public int hashCode() {
            Object object = this.getKey();
            int n = object != null ? object.hashCode() : 0;
            object = this.getValue();
            if (object != null) {
                n ^= object.hashCode();
            }
            return n;
        }
    }
}

