/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.tree.TreeNode;
import org.geotoolkit.gui.swing.tree.DefaultMutableTreeNode;
import org.geotoolkit.gui.swing.tree.MutableTreeNode;
import org.geotoolkit.gui.swing.tree.NamedTreeNode;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.metadata.AbstractMetadata;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.metadata.NullValuePolicy;
import org.geotoolkit.metadata.PropertyAccessor;
import org.geotoolkit.metadata.PropertyMap;
import org.geotoolkit.metadata.TypeValuePolicy;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

final class PropertyTree {
    private static final int PRECISION = 12;
    private final MetadataStandard standard;
    private final Locale locale;
    private transient NumberFormat numberFormat;
    private transient DateFormat dateFormat;

    public PropertyTree(MetadataStandard metadataStandard) {
        this(metadataStandard, Locale.getDefault());
    }

    public PropertyTree(MetadataStandard metadataStandard, Locale locale) {
        this.standard = metadataStandard;
        this.locale = locale;
    }

    final void parse(TreeNode treeNode, Object object) throws ParseException {
        Class<?> clazz = object.getClass();
        PropertyAccessor propertyAccessor = this.standard.getAccessorOptional(clazz);
        if (propertyAccessor == null) {
            throw new ParseException(Errors.format(198, clazz), 0);
        }
        int n = this.parse(treeNode, clazz, object, null, propertyAccessor);
        if (n != 0) {
            LogRecord logRecord = Errors.getResources(this.locale).getLogRecord(Level.WARNING, 47, n);
            logRecord.setSourceClassName("AbstractMetadata");
            logRecord.setSourceMethodName("parse");
            AbstractMetadata.LOGGER.log(logRecord);
        }
    }

    private <T> int parse(TreeNode treeNode, Class<? extends T> clazz, T t, Collection<? super T> collection, PropertyAccessor propertyAccessor) throws ParseException {
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = treeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            int n3;
            TreeNode treeNode2 = treeNode.getChildAt(i);
            String string = treeNode2.toString().trim();
            if (collection != null && PropertyTree.isCollectionElement(string)) {
                n += this.parse(treeNode2, clazz, null, collection, propertyAccessor);
                continue;
            }
            if (!hashSet.add(string)) {
                if (collection == null) {
                    throw new ParseException(Errors.format(46, string), 0);
                }
                assert (t != null) : hashSet;
                if (!collection.add(t)) {
                    ++n;
                }
                hashSet.clear();
                hashSet.add(string);
                t = null;
            }
            if ((n3 = propertyAccessor.indexOf(string)) < 0) {
                throw new ParseException(Errors.format(196, string), 0);
            }
            Class<?> clazz2 = propertyAccessor.type(n3, TypeValuePolicy.ELEMENT_TYPE);
            if (clazz2 == null) {
                throw new ParseException(Errors.format(195, string), 0);
            }
            PropertyAccessor propertyAccessor2 = this.standard.getAccessorOptional(clazz2 = this.standard.getImplementation(clazz2));
            if (propertyAccessor2 != null) {
                object = propertyAccessor.get(n3, t);
                if (object instanceof Collection) {
                    Collection collection2 = (Collection)object;
                    n += this.parse(treeNode2, clazz2, null, collection2, propertyAccessor2);
                } else {
                    n += this.parse(treeNode2, clazz2, object, null, propertyAccessor2);
                }
            } else {
                int n4 = treeNode2.getChildCount();
                Object[] objectArray = new Object[n4];
                for (int j = 0; j < n4; ++j) {
                    TreeNode treeNode3 = treeNode2.getChildAt(j);
                    object = PropertyTree.getUserObject(treeNode3, clazz2);
                    if (object == null) {
                        String string2 = treeNode3.toString();
                        object = Number.class.isAssignableFrom(clazz2) ? this.numberFormat.parse(string2) : (Date.class.isAssignableFrom(clazz2) ? this.dateFormat.parse(string2) : string2);
                    }
                    objectArray[j] = object;
                }
                object = Arrays.asList(objectArray);
            }
            if (t == null) {
                t = PropertyTree.newInstance(clazz);
            }
            propertyAccessor.set(n3, t, object, false);
        }
        if (collection != null && t != null && !collection.add(t)) {
            ++n;
        }
        return n;
    }

    private static Object getUserObject(TreeNode treeNode, Class<?> clazz) {
        Object object = Trees.getUserObject(treeNode);
        return clazz.isInstance(object) ? object : null;
    }

    private static <T> T newInstance(Class<? extends T> clazz) throws ParseException {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            ParseException parseException = new ParseException(Errors.format(25, clazz), 0);
            parseException.initCause(exception);
            throw parseException;
        }
    }

    public MutableTreeNode asTree(Object object) {
        String string = Classes.getShortName(this.standard.getInterface(object.getClass()));
        NamedTreeNode namedTreeNode = new NamedTreeNode(this.localize(string), object, true);
        this.append(namedTreeNode, object, 0);
        return namedTreeNode;
    }

    private void append(DefaultMutableTreeNode defaultMutableTreeNode, Object object, int n) {
        PropertyMap propertyMap;
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            propertyMap = (PropertyMap)object;
        } else if (object instanceof AbstractMetadata) {
            propertyMap = ((AbstractMetadata)object).asMap();
        } else {
            PropertyAccessor propertyAccessor = this.standard.getAccessorOptional(object.getClass());
            if (propertyAccessor != null) {
                propertyMap = new PropertyMap(object, propertyAccessor, NullValuePolicy.NON_EMPTY, KeyNamePolicy.JAVABEANS_PROPERTY);
            } else {
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    int n2 = collection.size() > 1 ? 1 : 0;
                    for (Object e : collection) {
                        if (PropertyAccessor.isEmpty(e)) continue;
                        this.append(defaultMutableTreeNode, e, n2);
                        if (n2 == 0) continue;
                        ++n2;
                    }
                    return;
                }
                String string = object instanceof CodeList ? this.localize((CodeList)object) : (object instanceof Date ? this.format((Date)object) : (object instanceof Number ? this.format((Number)object) : (object instanceof InternationalString ? ((InternationalString)object).toString(this.locale) : String.valueOf(object))));
                assert (!PropertyTree.isCollectionElement(string)) : string;
                defaultMutableTreeNode.add(new NamedTreeNode(string, object, false));
                return;
            }
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        if (n != 0) {
            String string = this.appendTitle(propertyMap.values(), new StringBuilder("[").append(this.format(n)).append("] ")).toString();
            assert (PropertyTree.isCollectionElement(string)) : string;
            defaultMutableTreeNode2 = new NamedTreeNode(string, object, true);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
            Object object2 = entry.getValue();
            if (PropertyAccessor.isEmpty(object2)) continue;
            String string = this.localize(entry.getKey());
            assert (!PropertyTree.isCollectionElement(string)) : string;
            NamedTreeNode namedTreeNode = new NamedTreeNode(string, object2, true);
            this.append(namedTreeNode, object2, 0);
            defaultMutableTreeNode2.add(namedTreeNode);
        }
    }

    private static boolean isCollectionElement(String string) {
        int n;
        int n2 = string.indexOf(91);
        if (n2 >= 0 && (n = string.indexOf(93, n2)) > n2) {
            while (--n2 >= 0) {
                if (!Character.isJavaIdentifierPart(string.charAt(n2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private StringBuilder appendTitle(Collection<?> collection, StringBuilder stringBuilder) {
        for (Object obj : collection) {
            if (!(obj instanceof CharSequence)) continue;
            String string = obj instanceof InternationalString ? ((InternationalString)obj).toString(this.locale) : obj.toString();
            if ((string = string.trim()).length() == 0) continue;
            return stringBuilder.append(string);
        }
        return stringBuilder.append('(').append(Vocabulary.getResources(this.locale).getString(280)).append(')');
    }

    private String format(Number number) {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getNumberInstance(this.locale);
            this.numberFormat.setMinimumFractionDigits(0);
        }
        int n = 0;
        if (!Classes.isInteger(number.getClass())) {
            n = 12;
            double d = Math.abs(number.doubleValue());
            if (d > 0.0) {
                int n2 = (int)Math.log10(d);
                if (Math.abs(n2) >= 12) {
                    return number.toString();
                }
                if (n2 >= 0) {
                    n -= n2;
                }
                n = Math.max(0, 12 - n);
            }
        }
        this.numberFormat.setMaximumFractionDigits(n);
        return this.numberFormat.format(number);
    }

    private String format(Date date) {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateTimeInstance(1, 1, this.locale);
        }
        return this.dateFormat.format(date);
    }

    private String localize(String string) {
        int n = (string = string.trim()).length();
        if (n != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Character.toUpperCase(string.charAt(0)));
            boolean bl = true;
            int n2 = 1;
            for (int i = 1; i < n; ++i) {
                boolean bl2 = Character.isUpperCase(string.charAt(i));
                if (bl2 != bl) {
                    int n3 = i;
                    if (bl) {
                        --n3;
                    }
                    if (n3 > n2) {
                        stringBuilder.append(string.substring(n2, n3)).append(' ');
                        n2 = n3;
                    }
                }
                bl = bl2;
            }
            String string2 = stringBuilder.append(string.substring(n2)).toString();
            if (!string2.equals(string)) {
                string = string2;
            }
        }
        return string;
    }

    private String localize(CodeList<?> codeList) {
        return codeList.name().trim().replace('_', ' ').toLowerCase(this.locale);
    }

    public static String toString(TreeNode treeNode) {
        StringBuilder stringBuilder = new StringBuilder();
        PropertyTree.toString(treeNode, stringBuilder, 0, System.getProperty("line.separator", "\n"));
        return stringBuilder.toString();
    }

    private static void toString(TreeNode treeNode, StringBuilder stringBuilder, int n, String string) {
        TreeNode treeNode2;
        int n2 = treeNode.getChildCount();
        if (n2 == 0) {
            if (treeNode.isLeaf()) {
                stringBuilder.append(Utilities.spaces(n)).append(treeNode).append(string);
            }
            return;
        }
        stringBuilder.append(Utilities.spaces(n)).append(treeNode).append(':');
        if (n2 == 1 && (treeNode2 = treeNode.getChildAt(0)).isLeaf()) {
            stringBuilder.append(' ').append(treeNode2).append(string);
            return;
        }
        for (int i = 0; i < n2; ++i) {
            TreeNode treeNode3 = treeNode.getChildAt(i);
            if (i == 0) {
                stringBuilder.append(string);
            }
            PropertyTree.toString(treeNode3, stringBuilder, n + 2, string);
        }
    }
}

